/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;

public class ActionReportJsonProprietaryReader
implements ProprietaryReader<ActionReport> {
    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(ActionReport.class);
    }

    public ActionReport readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public ActionReport readFrom(InputStream is, String contentType) throws IOException {
        CliActionReport cliActionReport;
        block8: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtils.copy((InputStream)is, (OutputStream)baos, (long)0L);
            String str = baos.toString("UTF-8");
            JsonParser parser = Json.createParser((Reader)new StringReader(str));
            try {
                parser.next();
                JsonObject json = parser.getObject();
                CliActionReport result = new CliActionReport();
                ActionReportJsonProprietaryReader.fillActionReport(result, json);
                cliActionReport = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException ex) {
                    LoggerRef.LOGGER.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
                    throw new IOException(ex);
                }
            }
            parser.close();
        }
        return cliActionReport;
    }

    public static void fillActionReport(ActionReport ar, JsonObject json) throws JsonException {
        ar.setActionExitCode(ActionReport.ExitCode.valueOf((String)json.getString("exit_code")));
        ar.setActionDescription(json.getString("command", null));
        String failure = json.getString("failure_cause", null);
        if (failure != null && !failure.isEmpty()) {
            ar.setFailureCause((Throwable)new Exception(failure));
        }
        ar.setExtraProperties((Properties)ActionReportJsonProprietaryReader.extractMap(json.getJsonObject("extraProperties"), new Properties()));
        ar.getTopMessagePart().setMessage(json.getString("top_message", json.getString("message", null)));
        Properties props = (Properties)ActionReportJsonProprietaryReader.extractMap(json.getJsonObject("properties"), new Properties());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof JsonString) {
                ar.getTopMessagePart().addProperty(String.valueOf(entry.getKey()), ((JsonString)entry.getValue()).getString());
                continue;
            }
            ar.getTopMessagePart().addProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        ActionReportJsonProprietaryReader.fillSubMessages(ar.getTopMessagePart(), json.getJsonArray("children"));
        JsonArray subJsons = json.getJsonArray("subReports");
        if (subJsons != null) {
            for (int i = 0; i < subJsons.size(); ++i) {
                JsonObject subJson = subJsons.getJsonObject(i);
                ActionReportJsonProprietaryReader.fillActionReport(ar.addSubActionsReport(), subJson);
            }
        }
    }

    private static void fillSubMessages(ActionReport.MessagePart mp, JsonArray json) throws JsonException {
        if (json == null) {
            return;
        }
        for (int i = 0; i < json.size(); ++i) {
            JsonObject subJson = json.getJsonObject(i);
            ActionReport.MessagePart child = mp.addChild();
            child.setMessage(subJson.getString("message", null));
            Properties props = (Properties)ActionReportJsonProprietaryReader.extractMap(subJson.getJsonObject("properties"), new Properties());
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object entryValue = entry.getValue();
                if (entryValue instanceof JsonString) {
                    child.addProperty(String.valueOf(entry.getKey()), ((JsonString)entry.getValue()).getString());
                } else {
                    child.addProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
                child.addProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            ActionReportJsonProprietaryReader.fillSubMessages(child, subJson.getJsonArray("children"));
        }
    }

    private static Object extractGeneral(Object obj) throws JsonException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JsonObject) {
            return ActionReportJsonProprietaryReader.extractMap((JsonObject)obj, null);
        }
        if (obj instanceof JsonArray) {
            return ActionReportJsonProprietaryReader.extractCollection((JsonArray)obj, null);
        }
        return obj;
    }

    private static Map extractMap(JsonObject json, Map preferredResult) throws JsonException {
        if (json == null) {
            return preferredResult;
        }
        if (preferredResult == null) {
            preferredResult = new HashMap();
        }
        for (Map.Entry entry : json.entrySet()) {
            preferredResult.put(entry.getKey(), ActionReportJsonProprietaryReader.extractGeneral(entry.getValue()));
        }
        return preferredResult;
    }

    private static Collection extractCollection(JsonArray array, Collection preferredResult) throws JsonException {
        if (array == null) {
            return preferredResult;
        }
        if (preferredResult == null) {
            preferredResult = new ArrayList<Object>(array.size());
        }
        for (int i = 0; i < array.size(); ++i) {
            preferredResult.add(ActionReportJsonProprietaryReader.extractGeneral(array.get(i)));
        }
        return preferredResult;
    }

    static class LoggerRef {
        private static final Logger LOGGER = AdminLoggerInfo.getLogger();

        LoggerRef() {
        }
    }
}

