/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.admin.remote.reader.ActionReportJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandState;

public class AdminCommandStateJsonProprietaryReader
implements ProprietaryReader<AdminCommandState> {
    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(AdminCommandState.class);
    }

    public AdminCommandState readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public AdminCommandState readFrom(InputStream is, String contentType) throws IOException {
        AdminCommandStateImpl adminCommandStateImpl;
        block8: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtils.copy((InputStream)is, (OutputStream)baos, (long)0L);
            String str = baos.toString("UTF-8");
            JsonParser parser = Json.createParser((Reader)new StringReader(str));
            try {
                parser.next();
                JsonObject json = parser.getObject();
                adminCommandStateImpl = AdminCommandStateJsonProprietaryReader.readAdminCommandState(json);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException ex) {
                    LoggerRef.logger.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
                    throw new IOException(ex);
                }
            }
            parser.close();
        }
        return adminCommandStateImpl;
    }

    public static AdminCommandStateImpl readAdminCommandState(JsonObject json) throws JsonException {
        String strState = json.getString("state", null);
        AdminCommandState.State state = strState == null ? null : AdminCommandState.State.valueOf((String)strState);
        boolean emptyPayload = json.getBoolean("empty-payload", true);
        CliActionReport ar = null;
        JsonObject jsonReport = json.getJsonObject("action-report");
        if (jsonReport != null) {
            ar = new CliActionReport();
            ActionReportJsonProprietaryReader.fillActionReport(ar, jsonReport);
        }
        String id = json.getString("id", null);
        return new AdminCommandStateImpl(state, ar, emptyPayload, id);
    }

    static class LoggerRef {
        private static final Logger logger = AdminLoggerInfo.getLogger();

        LoggerRef() {
        }
    }
}

