/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.ParamsWithPayload;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.remote.reader.ActionReportJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

public class MultipartProprietaryReader
implements ProprietaryReader<ParamsWithPayload> {
    private final ActionReportJsonProprietaryReader actionReportReader;

    public MultipartProprietaryReader() {
        this(new ActionReportJsonProprietaryReader());
    }

    public MultipartProprietaryReader(ActionReportJsonProprietaryReader actionReportReader) {
        this.actionReportReader = actionReportReader;
    }

    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        if (mimetype == null || mimetype.startsWith("*/") || mimetype.startsWith("multipart/")) {
            return ParamsWithPayload.class.isAssignableFrom(type);
        }
        return false;
    }

    public ParamsWithPayload readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public ParamsWithPayload readFrom(InputStream is, String contentType) throws IOException {
        RestPayloadImpl.Inbound payload = null;
        ActionReport actionReport = null;
        ParameterMap parameters = null;
        Properties mtProps = MultipartProprietaryReader.parseHeaderParams(contentType);
        String boundary = mtProps.getProperty("boundary");
        if (!StringUtils.ok((String)boundary)) {
            throw new IOException("ContentType does not define boundary");
        }
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(-1L);
        MIMEMessage mimeMessage = new MIMEMessage(is, boundary, mimeConfig);
        for (MIMEPart mimePart : mimeMessage.getAttachments()) {
            String ct;
            String cd = MultipartProprietaryReader.getFirst(mimePart.getHeader("Content-Disposition"));
            if (!StringUtils.ok((String)cd)) {
                cd = "file";
            }
            cd = cd.trim();
            Properties cdParams = MultipartProprietaryReader.parseHeaderParams(cd);
            if (cd.startsWith("form-data")) {
                if (!StringUtils.ok((String)cdParams.getProperty("name"))) {
                    throw new IOException("Form-data Content-Disposition does not contains name parameter.");
                }
                if (parameters == null) {
                    parameters = new ParameterMap();
                }
                parameters.add((Object)cdParams.getProperty("name"), (Object)MultipartProprietaryReader.stream2String(mimePart.readOnce()));
                continue;
            }
            if (cd.contains("name=\"ActionReport\"") && mimePart.getContentType() != null && mimePart.getContentType().startsWith("application/json")) {
                actionReport = this.actionReportReader.readFrom(mimePart.readOnce(), "application/json");
                continue;
            }
            String name = "noname";
            if (cdParams.containsKey("name")) {
                name = cdParams.getProperty("name");
            } else if (cdParams.containsKey("filename")) {
                name = cdParams.getProperty("filename");
            }
            if (payload == null) {
                payload = new RestPayloadImpl.Inbound();
            }
            if (!StringUtils.ok((String)(ct = mimePart.getContentType())) || ct.trim().startsWith("text/plain")) {
                payload.add(name, MultipartProprietaryReader.stream2String(mimePart.readOnce()), mimePart.getAllHeaders());
                continue;
            }
            payload.add(name, mimePart.read(), ct, mimePart.getAllHeaders());
        }
        return new ParamsWithPayload(payload, parameters, actionReport);
    }

    private static Properties parseHeaderParams(String contentType) {
        Properties result = new Properties();
        if (contentType == null) {
            return result;
        }
        int ind = contentType.indexOf(59);
        if (ind < 0) {
            return result;
        }
        contentType = contentType.substring(ind + 1);
        boolean parsingKey = true;
        boolean quoted = false;
        String key = "";
        StringBuilder tmp = new StringBuilder();
        block5: for (char ch : contentType.toCharArray()) {
            switch (ch) {
                case '\"': {
                    quoted = !quoted;
                    continue block5;
                }
                case '=': {
                    if (parsingKey && !quoted) {
                        key = tmp.toString();
                        tmp.setLength(0);
                        parsingKey = false;
                        continue block5;
                    }
                    tmp.append(ch);
                    continue block5;
                }
                case ';': {
                    if (quoted) {
                        tmp.append(ch);
                        continue block5;
                    }
                    if (parsingKey) continue block5;
                    parsingKey = true;
                    result.setProperty(key.trim(), tmp.toString().trim());
                    key = "";
                    tmp.setLength(0);
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        if (key.length() > 0) {
            result.setProperty(key.trim(), tmp.toString().trim());
        }
        return result;
    }

    private static String getFirst(List<String> lst) {
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stream2String(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try {
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            while ((count = is.read(buff)) > 0) {
                baos.write(buff, 0, count);
            }
            String string = baos.toString("UTF-8");
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

