/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

public class RowFormatter {
    private int numRows = -1;
    private final String[] headings;

    public RowFormatter(String[] h) {
        this.headings = h;
        this.numRows = this.headings.length;
    }

    public String addColumn(Object[] objs) {
        if (this.numRows != -1 && objs.length != this.numRows) {
            throw new IllegalArgumentException(String.format("invalid number of columns (%d), expected (%d)", objs.length, this.numRows));
        }
        int longestValue = 0;
        for (int i = 0; i < this.numRows; ++i) {
            if (this.headings == null || this.headings[i].length() <= longestValue) continue;
            longestValue = this.headings[i].length();
        }
        StringBuilder sb = new StringBuilder();
        String formattedline = "%1$-" + (longestValue += 2) + "s:%2$-1s";
        for (int i = 0; i < this.numRows; ++i) {
            sb.append(String.format(formattedline, this.headings[i], objs[i])).append("\n");
        }
        return sb.toString();
    }
}

