/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_delete-docker-container")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="_delete-docker-container", description="Deletes a Docker Container")})
public class DeleteDockerContainerCommand
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(DeleteDockerContainerCommand.class.getName());
    @Param(name="instanceName", alias="instance", primary=true)
    private String instanceName;
    @Param(name="nodeName", alias="node")
    private String nodeName;
    @Inject
    Nodes nodes;
    @Inject
    Servers servers;

    public void execute(AdminCommandContext adminCommandContext) {
        ActionReport actionReport = adminCommandContext.getActionReport();
        Node node = this.nodes.getNode(this.nodeName);
        Server server = this.servers.getServer(this.instanceName);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = null;
        webTarget = Boolean.valueOf(node.getUseTls()) != false ? client.target("https://" + node.getNodeHost() + ":" + node.getDockerPort() + "/containers/" + server.getDockerContainerId()) : client.target("http://" + node.getNodeHost() + ":" + node.getDockerPort() + "/containers/" + server.getDockerContainerId());
        Response response = null;
        try {
            response = webTarget.request(new String[]{"application/json"}).delete();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Encountered an exception sending request to Docker: \n", ex);
        }
        if (response != null) {
            Response.StatusType responseStatus = response.getStatusInfo();
            if (!responseStatus.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                actionReport.failure(logger, "Failed to delete Docker Container, user action will be required: \n" + responseStatus.getReasonPhrase());
            }
        } else {
            actionReport.failure(logger, "Failed to delete Docker Container, user action will be required");
        }
    }
}

