/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.cdi.auth.roles;

import fish.payara.appserver.cdi.auth.roles.NonSerializableProperties;
import fish.payara.cdi.auth.roles.CallerAccessException;
import fish.payara.cdi.auth.roles.LogicalOperator;
import fish.payara.cdi.auth.roles.RolesPermitted;
import jakarta.annotation.Priority;
import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.SecurityContext;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.glassfish.soteria.cdi.AnnotationELPProcessor;
import org.glassfish.soteria.cdi.CdiUtils;

@Interceptor
@RolesPermitted
@Priority(value=5000)
public class RolesPermittedInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Bean<?> interceptedBean;
    private final NonSerializableProperties lazyProperties;
    @Context
    private transient HttpServletRequest request;
    @Context
    private transient HttpServletResponse response;

    @Inject
    public RolesPermittedInterceptor(@Intercepted Bean<?> interceptedBean) {
        this.interceptedBean = interceptedBean;
        this.lazyProperties = new NonSerializableProperties();
    }

    @AroundInvoke
    public Object method(InvocationContext invocationContext) throws Exception {
        RolesPermitted roles = this.getRolesPermitted(invocationContext);
        boolean isAccessPermitted = this.checkAccessPermitted(roles, invocationContext);
        if (!isAccessPermitted) {
            throw new CallerAccessException("Caller was not permitted access to a protected resource");
        }
        return invocationContext.proceed();
    }

    public boolean checkAccessPermitted(RolesPermitted roles, InvocationContext invocationContext) {
        this.authenticate(roles.value());
        ELProcessor eLProcessor = null;
        if (AnnotationELPProcessor.hasAnyELExpression((String[])roles.value())) {
            eLProcessor = this.getElProcessor(invocationContext);
        }
        List<String> permittedRoles = Arrays.asList(roles.value());
        SecurityContext securityContext = this.lazyProperties.getSecurityContext();
        if (LogicalOperator.OR.equals((Object)roles.semantics())) {
            for (String role : permittedRoles) {
                if (eLProcessor != null && AnnotationELPProcessor.hasAnyELExpression((String[])new String[]{role})) {
                    role = AnnotationELPProcessor.evalELExpression((ELProcessor)eLProcessor, (String)role);
                }
                if (!securityContext.isCallerInRole(role)) continue;
                return true;
            }
        } else if (LogicalOperator.AND.equals((Object)roles.semantics())) {
            for (String role : permittedRoles) {
                if (eLProcessor != null && AnnotationELPProcessor.hasAnyELExpression((String[])new String[]{role})) {
                    role = AnnotationELPProcessor.evalELExpression((ELProcessor)eLProcessor, (String)role);
                }
                if (securityContext.isCallerInRole(role)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private RolesPermitted getRolesPermitted(InvocationContext invocationContext) {
        BeanManager beanManager;
        Optional<RolesPermitted> optionalRolesPermitted;
        Set bindings = (Set)invocationContext.getContextData().get("org.jboss.weld.interceptor.bindings");
        if (bindings != null) {
            optionalRolesPermitted = bindings.stream().filter(annotation -> annotation.annotationType().equals(RolesPermitted.class)).findAny().map(RolesPermitted.class::cast);
            if (optionalRolesPermitted.isPresent()) {
                return optionalRolesPermitted.get();
            }
        }
        if ((optionalRolesPermitted = RolesPermittedInterceptor.getAnnotationFromMethod(beanManager = this.lazyProperties.getBeanManager(), invocationContext.getMethod(), RolesPermitted.class)).isPresent()) {
            return optionalRolesPermitted.get();
        }
        optionalRolesPermitted = CdiUtils.getAnnotation((BeanManager)beanManager, (Class)this.interceptedBean.getBeanClass(), RolesPermitted.class);
        if (optionalRolesPermitted.isPresent()) {
            return (RolesPermitted)optionalRolesPermitted.get();
        }
        throw new IllegalStateException("@RolesPermitted not found on " + this.interceptedBean.getBeanClass());
    }

    public static <A extends Annotation> Optional<A> getAnnotationFromMethod(BeanManager beanManager, Method annotatedMethod, Class<A> annotationType) {
        if (annotatedMethod.isAnnotationPresent(annotationType)) {
            return Optional.of(annotatedMethod.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedMethod.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    private ELProcessor getElProcessor(InvocationContext invocationContext) {
        BeanManager beanManager = this.lazyProperties.getBeanManager();
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(beanManager.getELResolver());
        elProcessor.defineBean("self", invocationContext.getTarget());
        Parameter[] parameters = invocationContext.getMethod().getParameters();
        Object[] values = invocationContext.getParameters();
        boolean paramAdded = false;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            Named named = param.getAnnotation(Named.class);
            String key = null;
            if (named == null || (key = named.value().trim()).isEmpty()) continue;
            elProcessor.defineBean(key, values[i]);
            paramAdded = true;
        }
        if (!paramAdded && parameters.length == 1) {
            elProcessor.defineBean("param", values[0]);
        }
        return elProcessor;
    }

    private void authenticate(String[] roles) {
        SecurityContext securityContext = this.lazyProperties.getSecurityContext();
        if (this.request != null && this.response != null && roles.length > 0 && !RolesPermittedInterceptor.isAuthenticated(securityContext)) {
            AuthenticationStatus status = securityContext.authenticate(this.request, this.response, AuthenticationParameters.withParams());
            if (status == AuthenticationStatus.NOT_DONE || status == AuthenticationStatus.SEND_FAILURE) {
                throw new NotAuthorizedException("Authentication resulted in " + status, Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            if (status == AuthenticationStatus.SUCCESS && !RolesPermittedInterceptor.isAuthenticated(securityContext)) {
                throw new NotAuthorizedException("Authentication not done (i.e. no credential found)", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
    }

    private static boolean isAuthenticated(SecurityContext securityContext) {
        return securityContext.getCallerPrincipal() != null;
    }
}

