/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.StringUtils;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.nucleus.healthcheck.HealthCheckConstants;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.CheckerConfigurationType;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.HoggingThreadsChecker;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileHealthCheckerConfiguration;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileMetricsChecker;
import fish.payara.nucleus.healthcheck.configuration.MonitoredMetric;
import fish.payara.nucleus.healthcheck.configuration.StuckThreadsChecker;
import fish.payara.nucleus.healthcheck.configuration.ThresholdDiagnosticsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.types.Property;

@Service(name="get-healthcheck-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.healthcheck.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-healthcheck-configuration", description="List HealthCheck Configuration")})
public class GetHealthCheckConfiguration
implements AdminCommand,
HealthCheckConstants {
    static final String[] baseHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health"};
    static final String[] hoggingThreadsHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health", "Threshold Percentage", "Retry Count"};
    static final String[] thresholdDiagnosticsHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health", "Critical Threshold", "Warning Threshold", "Good Threshold"};
    static final String[] stuckThreadsHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health", "Threshold Time", "Threshold Unit", "Blacklist Patterns"};
    static final String[] MPHealthCheckHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health", "Timeout"};
    static final String[] microProfileMetricsCheckHeaders = new String[]{"Name", "Enabled", "Time", "Unit", "Add to MicroProfile Health"};
    static final String[] monitoredMicroProfileMetricHeaders = new String[]{"Monitored Metric Name", "Description"};
    static final String[] notifierHeaders = new String[]{"Name", "Notifier Enabled"};
    private final String garbageCollectorPropertyName = "garbageCollector";
    private final String cpuUsagePropertyName = "cpuUsage";
    private final String connectionPoolPropertyName = "connectionPool";
    private final String heapMemoryUsagePropertyName = "heapMemoryUsage";
    private final String machineMemoryUsagePropertyName = "machineMemoryUsage";
    private final String hoggingThreadsPropertyName = "hoggingThreads";
    private final String stuckThreadsPropertyName = "stuckThreads";
    private final String mpHealthcheckPropertyName = "mpHealth";
    private final String microProfileMetricsPropertyName = "microProfileMetrics";
    @Inject
    ServiceLocator habitat;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport mainActionReport = context.getActionReport();
        ActionReport baseActionReport = mainActionReport.addSubActionsReport();
        ActionReport hoggingThreadsActionReport = mainActionReport.addSubActionsReport();
        ActionReport thresholdDiagnosticsActionReport = mainActionReport.addSubActionsReport();
        ActionReport stuckThreadsActionReport = mainActionReport.addSubActionsReport();
        ActionReport mpHealthcheckCheckerActionReport = mainActionReport.addSubActionsReport();
        ActionReport microProfileMetricsActionReport = mainActionReport.addSubActionsReport();
        ActionReport monitoredMicroProfileMetricsActionReport = mainActionReport.addSubActionsReport();
        ColumnFormatter baseColumnFormatter = new ColumnFormatter(baseHeaders);
        ColumnFormatter hoggingThreadsColumnFormatter = new ColumnFormatter(hoggingThreadsHeaders);
        ColumnFormatter stuckThreadsColumnFormatter = new ColumnFormatter(stuckThreadsHeaders);
        ColumnFormatter thresholdDiagnosticsColumnFormatter = new ColumnFormatter(thresholdDiagnosticsHeaders);
        ColumnFormatter mpHealthCheckColumnFormatter = new ColumnFormatter(MPHealthCheckHeaders);
        ColumnFormatter microProfileMetricsColumnFormatter = new ColumnFormatter(microProfileMetricsCheckHeaders);
        ColumnFormatter monitoredMicroProfileMetricsColumnFormatter = new ColumnFormatter(monitoredMicroProfileMetricHeaders);
        ColumnFormatter notifiersColumnFormatter = new ColumnFormatter(notifierHeaders);
        HealthCheckServiceConfiguration configuration = (HealthCheckServiceConfiguration)config.getExtensionByType(HealthCheckServiceConfiguration.class);
        List allServiceHandles = this.habitat.getAllServiceHandles(BaseHealthCheck.class, new Annotation[0]);
        List allNotifierServiceHandles = this.habitat.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        mainActionReport.appendMessage("Health Check Service Configuration is enabled?: " + configuration.getEnabled() + "\n");
        if (Boolean.parseBoolean(configuration.getEnabled())) {
            mainActionReport.appendMessage("Historical Tracing Enabled?: " + configuration.getHistoricalTraceEnabled() + "\n");
            if (Boolean.parseBoolean(configuration.getHistoricalTraceEnabled())) {
                mainActionReport.appendMessage("Historical Tracing Store Size: " + configuration.getHistoricalTraceStoreSize() + "\n");
            }
            if (StringUtils.ok((String)configuration.getHistoricalTraceStoreTimeout())) {
                mainActionReport.appendMessage("Health Check Historical Tracing Store Timeout in Seconds: " + configuration.getHistoricalTraceStoreTimeout() + "\n");
            }
        }
        Properties mainExtraProps = new Properties();
        HashMap<String, String> mainExtraPropsMap = new HashMap<String, String>();
        mainExtraPropsMap.put("enabled", configuration.getEnabled());
        mainExtraPropsMap.put("historicalTraceEnabled", configuration.getHistoricalTraceEnabled());
        mainExtraPropsMap.put("historicalTraceStoreSize", configuration.getHistoricalTraceStoreSize());
        mainExtraPropsMap.put("historicalTraceStoreTimeout", configuration.getHistoricalTraceStoreTimeout());
        mainExtraProps.put("healthcheckConfiguration", mainExtraPropsMap);
        mainActionReport.setExtraProperties(mainExtraProps);
        List<String> notifiers = configuration.getNotifierList();
        if (!notifiers.isEmpty()) {
            Properties extraProps = new Properties();
            for (ServiceHandle serviceHandle : allNotifierServiceHandles) {
                String notifierClassName = serviceHandle.getActiveDescriptor().getImplementationClass().getSimpleName();
                String notifierName = NotifierUtils.getNotifierName((ActiveDescriptor)serviceHandle.getActiveDescriptor());
                Object[] values = new Object[]{notifierName, notifiers.contains(notifierName)};
                notifiersColumnFormatter.addRow(values);
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("notifierName", values[0]);
                map.put("notifierEnabled", values[1]);
                extraProps.put("notifierList" + notifierClassName, map);
            }
            mainActionReport.getExtraProperties().putAll((Map<?, ?>)extraProps);
            mainActionReport.appendMessage(notifiersColumnFormatter.toString());
            mainActionReport.appendMessage(StringUtils.EOL);
        }
        mainActionReport.appendMessage("Below are the list of configuration details of each checker listed by its name.");
        mainActionReport.appendMessage(StringUtils.EOL);
        Properties baseExtraProps = new Properties();
        Properties hoggingThreadsExtraProps = new Properties();
        Properties stuckThreadsExtrasProps = new Properties();
        Properties thresholdDiagnosticsExtraProps = new Properties();
        Properties mpHealthcheckExtrasProps = new Properties();
        Properties microProfileMetricsExtrasProps = new Properties();
        Properties monitoredMicroProfileMetricsExtrasProps = new Properties();
        for (ServiceHandle serviceHandle : allServiceHandles) {
            Object[] values;
            Object checker = configuration.getCheckerByType(((BaseHealthCheck)serviceHandle.getService()).getCheckerType());
            if (checker instanceof HoggingThreadsChecker) {
                HoggingThreadsChecker hoggingThreadsChecker = (HoggingThreadsChecker)checker;
                values = new Object[]{hoggingThreadsChecker.getName(), hoggingThreadsChecker.getEnabled(), hoggingThreadsChecker.getTime(), hoggingThreadsChecker.getUnit(), hoggingThreadsChecker.getAddToMicroProfileHealth(), hoggingThreadsChecker.getThresholdPercentage(), hoggingThreadsChecker.getRetryCount()};
                hoggingThreadsColumnFormatter.addRow(values);
                this.addHoggingThreadsCheckerExtraProps(hoggingThreadsExtraProps, hoggingThreadsChecker);
                continue;
            }
            if (checker instanceof ThresholdDiagnosticsChecker) {
                ThresholdDiagnosticsChecker thresholdDiagnosticsChecker = (ThresholdDiagnosticsChecker)checker;
                values = new Object[8];
                values[0] = thresholdDiagnosticsChecker.getName();
                values[1] = thresholdDiagnosticsChecker.getEnabled();
                values[2] = thresholdDiagnosticsChecker.getTime();
                values[3] = thresholdDiagnosticsChecker.getUnit();
                values[4] = thresholdDiagnosticsChecker.getAddToMicroProfileHealth();
                Property thresholdCriticalProperty = thresholdDiagnosticsChecker.getProperty("threshold-critical");
                values[5] = thresholdCriticalProperty != null ? thresholdCriticalProperty.getValue() : "-";
                Property thresholdWarningProperty = thresholdDiagnosticsChecker.getProperty("threshold-warning");
                values[6] = thresholdWarningProperty != null ? thresholdWarningProperty.getValue() : "-";
                Property thresholdGoodProperty = thresholdDiagnosticsChecker.getProperty("threshold-good");
                values[7] = thresholdGoodProperty != null ? thresholdGoodProperty.getValue() : "-";
                thresholdDiagnosticsColumnFormatter.addRow(values);
                this.addThresholdDiagnosticsCheckerExtraProps(thresholdDiagnosticsExtraProps, thresholdDiagnosticsChecker);
                continue;
            }
            if (checker instanceof StuckThreadsChecker) {
                StuckThreadsChecker stuckThreadsChecker = (StuckThreadsChecker)checker;
                values = new Object[]{stuckThreadsChecker.getName(), stuckThreadsChecker.getEnabled(), stuckThreadsChecker.getTime(), stuckThreadsChecker.getUnit(), stuckThreadsChecker.getAddToMicroProfileHealth(), stuckThreadsChecker.getThreshold(), stuckThreadsChecker.getThresholdTimeUnit(), stuckThreadsChecker.getBlacklistPatterns()};
                stuckThreadsColumnFormatter.addRow(values);
                this.addStuckThreadsCheckerExtrasProps(stuckThreadsExtrasProps, stuckThreadsChecker);
                continue;
            }
            if (checker instanceof MicroProfileHealthCheckerConfiguration) {
                MicroProfileHealthCheckerConfiguration mpHealthcheckChecker = (MicroProfileHealthCheckerConfiguration)checker;
                values = new Object[]{mpHealthcheckChecker.getName(), mpHealthcheckChecker.getEnabled(), mpHealthcheckChecker.getTime(), mpHealthcheckChecker.getUnit(), mpHealthcheckChecker.getAddToMicroProfileHealth(), mpHealthcheckChecker.getTimeout()};
                mpHealthCheckColumnFormatter.addRow(values);
                this.addMPHealthcheckCheckerExtrasProps(mpHealthcheckExtrasProps, mpHealthcheckChecker);
                continue;
            }
            if (checker instanceof MicroProfileMetricsChecker) {
                MicroProfileMetricsChecker microProfileMetricsChecker = (MicroProfileMetricsChecker)checker;
                values = new Object[]{microProfileMetricsChecker.getName(), microProfileMetricsChecker.getEnabled(), microProfileMetricsChecker.getTime(), microProfileMetricsChecker.getUnit(), microProfileMetricsChecker.getAddToMicroProfileHealth()};
                microProfileMetricsColumnFormatter.addRow(values);
                this.addMicroProfileMetricsCheckerExtrasProps(microProfileMetricsExtrasProps, microProfileMetricsChecker);
                HashMap<String, String> monitoredAttributes = new HashMap<String, String>();
                List<MonitoredMetric> metrics = microProfileMetricsChecker.getMonitoredMetrics();
                if (metrics.isEmpty()) continue;
                for (MonitoredMetric monitoredBean : metrics) {
                    Object[] metricValues = new Object[]{monitoredBean.getMetricName(), monitoredBean.getDescription()};
                    monitoredMicroProfileMetricsColumnFormatter.addRow(metricValues);
                    monitoredAttributes.put("MetricsName", monitoredBean.getMetricName());
                }
                monitoredMicroProfileMetricsExtrasProps.put("monitoredMetrics", monitoredAttributes);
                continue;
            }
            if (checker == null) continue;
            Object[] values2 = new Object[]{checker.getName(), checker.getEnabled(), checker.getTime(), checker.getUnit(), checker.getAddToMicroProfileHealth()};
            baseColumnFormatter.addRow(values2);
            GetHealthCheckConfiguration.addBaseCheckerExtraProps(baseExtraProps, checker);
        }
        if (!baseColumnFormatter.getContent().isEmpty()) {
            baseActionReport.setMessage(baseColumnFormatter.toString());
            baseActionReport.appendMessage(StringUtils.EOL);
        }
        if (!hoggingThreadsColumnFormatter.getContent().isEmpty()) {
            hoggingThreadsActionReport.setMessage(hoggingThreadsColumnFormatter.toString());
            hoggingThreadsActionReport.appendMessage(StringUtils.EOL);
        }
        if (!thresholdDiagnosticsColumnFormatter.getContent().isEmpty()) {
            thresholdDiagnosticsActionReport.setMessage(thresholdDiagnosticsColumnFormatter.toString());
            thresholdDiagnosticsActionReport.appendMessage(StringUtils.EOL);
        }
        if (!stuckThreadsColumnFormatter.getContent().isEmpty()) {
            stuckThreadsActionReport.setMessage(stuckThreadsColumnFormatter.toString());
            stuckThreadsActionReport.appendMessage(StringUtils.EOL);
        }
        if (!mpHealthCheckColumnFormatter.getContent().isEmpty()) {
            mpHealthcheckCheckerActionReport.setMessage(mpHealthCheckColumnFormatter.toString());
            mpHealthcheckCheckerActionReport.appendMessage(StringUtils.EOL);
        }
        if (!microProfileMetricsColumnFormatter.getContent().isEmpty()) {
            microProfileMetricsActionReport.setMessage(microProfileMetricsColumnFormatter.toString());
            microProfileMetricsActionReport.appendMessage(StringUtils.EOL);
        }
        if (!monitoredMicroProfileMetricsColumnFormatter.getContent().isEmpty()) {
            monitoredMicroProfileMetricsActionReport.setMessage(monitoredMicroProfileMetricsColumnFormatter.toString());
            monitoredMicroProfileMetricsActionReport.appendMessage(StringUtils.EOL);
        }
        baseExtraProps = this.checkCheckerPropertyPresence(thresholdDiagnosticsExtraProps, "garbageCollector");
        hoggingThreadsExtraProps = this.checkCheckerPropertyPresence(hoggingThreadsExtraProps, "hoggingThreads");
        stuckThreadsExtrasProps = this.checkCheckerPropertyPresence(stuckThreadsExtrasProps, "stuckThreads");
        thresholdDiagnosticsExtraProps = this.checkCheckerPropertyPresence(thresholdDiagnosticsExtraProps, "cpuUsage");
        thresholdDiagnosticsExtraProps = this.checkCheckerPropertyPresence(thresholdDiagnosticsExtraProps, "connectionPool");
        thresholdDiagnosticsExtraProps = this.checkCheckerPropertyPresence(thresholdDiagnosticsExtraProps, "heapMemoryUsage");
        thresholdDiagnosticsExtraProps = this.checkCheckerPropertyPresence(thresholdDiagnosticsExtraProps, "machineMemoryUsage");
        mpHealthcheckExtrasProps = this.checkCheckerPropertyPresence(mpHealthcheckExtrasProps, "mpHealth");
        microProfileMetricsExtrasProps = this.checkCheckerPropertyPresence(microProfileMetricsExtrasProps, "microProfileMetrics");
        baseActionReport.setExtraProperties(baseExtraProps);
        hoggingThreadsActionReport.setExtraProperties(hoggingThreadsExtraProps);
        thresholdDiagnosticsActionReport.setExtraProperties(thresholdDiagnosticsExtraProps);
        stuckThreadsActionReport.setExtraProperties(stuckThreadsExtrasProps);
        mpHealthcheckCheckerActionReport.setExtraProperties(mpHealthcheckExtrasProps);
        microProfileMetricsActionReport.setExtraProperties(microProfileMetricsExtrasProps);
        monitoredMicroProfileMetricsActionReport.setExtraProperties(monitoredMicroProfileMetricsExtrasProps);
        mainActionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void addHoggingThreadsCheckerExtraProps(Properties hoggingThreadsExtraProps, HoggingThreadsChecker hoggingThreadsChecker) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(7);
        extraPropsMap.put("checkerName", hoggingThreadsChecker.getName());
        extraPropsMap.put("enabled", hoggingThreadsChecker.getEnabled());
        extraPropsMap.put("time", hoggingThreadsChecker.getTime());
        extraPropsMap.put("unit", hoggingThreadsChecker.getUnit());
        extraPropsMap.put("addToMicroProfileHealth", hoggingThreadsChecker.getAddToMicroProfileHealth());
        extraPropsMap.put("threshold-percentage", hoggingThreadsChecker.getThresholdPercentage());
        extraPropsMap.put("retry-count", hoggingThreadsChecker.getRetryCount());
        hoggingThreadsExtraProps.put("hoggingThreads", extraPropsMap);
    }

    private void addStuckThreadsCheckerExtrasProps(Properties stuckThreadsExtrasProps, StuckThreadsChecker stuckThreadsChecker) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(7);
        extraPropsMap.put("checkerName", stuckThreadsChecker.getName());
        extraPropsMap.put("enabled", stuckThreadsChecker.getEnabled());
        extraPropsMap.put("time", stuckThreadsChecker.getTime());
        extraPropsMap.put("unit", stuckThreadsChecker.getUnit());
        extraPropsMap.put("addToMicroProfileHealth", stuckThreadsChecker.getAddToMicroProfileHealth());
        Long thesholdInMillis = GetHealthCheckConfiguration.stuckThreadsThesholdInMillis(stuckThreadsChecker);
        if (thesholdInMillis != null && thesholdInMillis <= 0L) {
            extraPropsMap.put("threshold", "1");
            extraPropsMap.put("thresholdUnit", TimeUnit.MILLISECONDS.name());
        } else {
            extraPropsMap.put("threshold", stuckThreadsChecker.getThreshold());
            extraPropsMap.put("thresholdUnit", stuckThreadsChecker.getThresholdTimeUnit());
        }
        extraPropsMap.put("blacklistPatterns", stuckThreadsChecker.getBlacklistPatterns());
        stuckThreadsExtrasProps.put("stuckThreads", extraPropsMap);
    }

    private static Long stuckThreadsThesholdInMillis(StuckThreadsChecker stuckThreadsChecker) {
        try {
            return TimeUnit.MILLISECONDS.convert(Long.parseLong(stuckThreadsChecker.getThreshold()), TimeUnit.valueOf(stuckThreadsChecker.getThresholdTimeUnit()));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private void addMPHealthcheckCheckerExtrasProps(Properties mpHealthcheckExtrasProps, MicroProfileHealthCheckerConfiguration mpHealthcheckCheck) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(6);
        extraPropsMap.put("checkerName", mpHealthcheckCheck.getName());
        extraPropsMap.put("enabled", mpHealthcheckCheck.getEnabled());
        extraPropsMap.put("time", mpHealthcheckCheck.getTime());
        extraPropsMap.put("unit", mpHealthcheckCheck.getUnit());
        extraPropsMap.put("addToMicroProfileHealth", mpHealthcheckCheck.getAddToMicroProfileHealth());
        extraPropsMap.put("timeout", mpHealthcheckCheck.getTimeout());
        mpHealthcheckExtrasProps.put("mpHealth", extraPropsMap);
    }

    private void addMicroProfileMetricsCheckerExtrasProps(Properties microProfileMetricsExtrasProps, MicroProfileMetricsChecker microProfileMetricsChecker) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(4);
        extraPropsMap.put("checkerName", microProfileMetricsChecker.getName());
        extraPropsMap.put("enabled", microProfileMetricsChecker.getEnabled());
        extraPropsMap.put("time", microProfileMetricsChecker.getTime());
        extraPropsMap.put("unit", microProfileMetricsChecker.getUnit());
        microProfileMetricsExtrasProps.put("microProfileMetrics", extraPropsMap);
    }

    private void addThresholdDiagnosticsCheckerExtraProps(Properties thresholdDiagnosticsExtraProps, ThresholdDiagnosticsChecker thresholdDiagnosticsChecker) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(8);
        extraPropsMap.put("checkerName", thresholdDiagnosticsChecker.getName());
        extraPropsMap.put("enabled", thresholdDiagnosticsChecker.getEnabled());
        extraPropsMap.put("time", thresholdDiagnosticsChecker.getTime());
        extraPropsMap.put("unit", thresholdDiagnosticsChecker.getUnit());
        extraPropsMap.put("addToMicroProfileHealth", thresholdDiagnosticsChecker.getAddToMicroProfileHealth());
        if (thresholdDiagnosticsChecker.getProperty("threshold-critical") != null) {
            extraPropsMap.put("thresholdCritical", thresholdDiagnosticsChecker.getProperty("threshold-critical").getValue());
        }
        if (thresholdDiagnosticsChecker.getProperty("threshold-warning") != null) {
            extraPropsMap.put("thresholdWarning", thresholdDiagnosticsChecker.getProperty("threshold-warning").getValue());
        }
        if (thresholdDiagnosticsChecker.getProperty("threshold-good") != null) {
            extraPropsMap.put("thresholdGood", thresholdDiagnosticsChecker.getProperty("threshold-good").getValue());
        }
        ConfigView view = ConfigSupport.getImpl((ConfigBeanProxy)thresholdDiagnosticsChecker);
        CheckerConfigurationType annotation = view.getProxyType().getAnnotation(CheckerConfigurationType.class);
        switch (annotation.type()) {
            case CONNECTION_POOL: {
                thresholdDiagnosticsExtraProps.put("connectionPool", extraPropsMap);
                break;
            }
            case CPU_USAGE: {
                thresholdDiagnosticsExtraProps.put("cpuUsage", extraPropsMap);
                break;
            }
            case GARBAGE_COLLECTOR: {
                thresholdDiagnosticsExtraProps.put("garbageCollector", extraPropsMap);
                break;
            }
            case HEAP_MEMORY_USAGE: {
                thresholdDiagnosticsExtraProps.put("heapMemoryUsage", extraPropsMap);
                break;
            }
            case MACHINE_MEMORY_USAGE: {
                thresholdDiagnosticsExtraProps.put("machineMemoryUsage", extraPropsMap);
                break;
            }
            case STUCK_THREAD: {
                thresholdDiagnosticsExtraProps.put("stuckThreads", extraPropsMap);
            }
        }
    }

    private static void addBaseCheckerExtraProps(Properties baseExtraProps, Checker checker) {
        HashMap<String, String> extraPropsMap = new HashMap<String, String>(5);
        extraPropsMap.put("checkerName", checker.getName());
        extraPropsMap.put("enabled", checker.getEnabled());
        extraPropsMap.put("time", checker.getTime());
        extraPropsMap.put("unit", checker.getUnit());
        extraPropsMap.put("addToMicroProfileHealth", checker.getAddToMicroProfileHealth());
    }

    private Properties checkCheckerPropertyPresence(Properties extraProps, String checkerName) {
        if (!extraProps.containsKey(checkerName)) {
            switch (checkerName) {
                case "garbageCollector": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "GBGC");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "hoggingThreads": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(6);
                    extraPropsMap.put("checkerName", "HOGT");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "cpuUsage": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "CPUC");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "connectionPool": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "CONP");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "heapMemoryUsage": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "HEAP");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "machineMemoryUsage": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "MEMM");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "stuckThreads": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(6);
                    extraPropsMap.put("checkerName", "STUCK");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "mpHealth": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(5);
                    extraPropsMap.put("checkerName", "MP");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                    break;
                }
                case "microProfileMetrics": {
                    HashMap<String, Object> extraPropsMap = new HashMap<String, Object>(7);
                    extraPropsMap.put("checkerName", "MPM");
                    extraProps.put(checkerName, GetHealthCheckConfiguration.populateDefaultValuesMap(extraPropsMap));
                }
            }
        }
        return extraProps;
    }

    private static Map<String, Object> populateDefaultValuesMap(Map<String, Object> extraPropsMap) {
        extraPropsMap.put("enabled", "false");
        extraPropsMap.put("time", "5");
        extraPropsMap.put("unit", "MINUTES");
        extraPropsMap.put("addToMicroProfileHealth", "false");
        if (extraPropsMap.containsValue("HOGT")) {
            extraPropsMap.put("threshold-percentage", "95");
            extraPropsMap.put("retry-count", "3");
        } else if (extraPropsMap.containsValue("STUCK")) {
            extraPropsMap.put("threshold", "5");
            extraPropsMap.put("thresholdUnit", "MINUTES");
        } else if (extraPropsMap.containsValue("MP")) {
            extraPropsMap.put("timeout", "30000");
        } else {
            if (extraPropsMap.containsKey("MPM")) {
                return extraPropsMap;
            }
            extraPropsMap.put("thresholdCritical", "80");
            extraPropsMap.put("thresholdWarning", "50");
            extraPropsMap.put("thresholdGood", "0");
        }
        return extraPropsMap;
    }
}

