/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.notification.jms;

import com.sun.enterprise.util.StringUtils;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.notification.jms.JmsNotifierConfiguration;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="jms-notifier")
@RunLevel(value=10)
public class JmsNotifierService
extends PayaraConfiguredNotifier<JmsNotifierConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(JmsNotifierService.class.getCanonicalName());
    private Connection connection;

    @Override
    public void bootstrap() {
        super.bootstrap();
        try {
            String contextFactoryClass = ((JmsNotifierConfiguration)this.configuration).getContextFactoryClass();
            String connectionFactoryName = ((JmsNotifierConfiguration)this.configuration).getConnectionFactoryName();
            String url = ((JmsNotifierConfiguration)this.configuration).getUrl();
            String username = ((JmsNotifierConfiguration)this.configuration).getUsername();
            String password = ((JmsNotifierConfiguration)this.configuration).getPassword();
            Properties env = new Properties();
            if (StringUtils.ok((String)contextFactoryClass)) {
                env.put("java.naming.factory.initial", contextFactoryClass);
            }
            if (StringUtils.ok((String)url)) {
                env.put("java.naming.provider.url", url);
            }
            if (StringUtils.ok((String)username)) {
                env.put("java.naming.security.principal", username);
            }
            if (StringUtils.ok((String)password)) {
                env.put("java.naming.security.credentials", password);
            }
            if (StringUtils.ok((String)connectionFactoryName)) {
                try {
                    InitialContext ctx = new InitialContext(env);
                    ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(connectionFactoryName);
                    this.connection = connectionFactory.createConnection();
                }
                catch (NoInitialContextException e) {
                    if (e.getRootCause() instanceof ClassNotFoundException) {
                        LOGGER.log(Level.SEVERE, "Context factory class cannot be found on classpath: " + ((JmsNotifierConfiguration)this.configuration).getContextFactoryClass());
                    }
                }
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, "Cannot lookup JMS resources", e);
        }
        catch (JMSException e) {
            LOGGER.log(Level.SEVERE, "Cannot create JMS connection", e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                LOGGER.log(Level.SEVERE, "Could not close connection", e);
            }
        }
    }

    @Override
    public void handleNotification(PayaraNotification event) {
        if (this.connection == null) {
            LOGGER.log(Level.SEVERE, "Invalid connection");
            return;
        }
        try (Session session = this.connection.createSession(false, 1);){
            Queue jmsQueue = session.createQueue(((JmsNotifierConfiguration)this.configuration).getQueueName());
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            TextMessage message = session.createTextMessage();
            message.setText(JmsNotifierService.getTextMessage(event));
            producer.send((Message)message);
            LOGGER.log(Level.FINE, "Message successfully sent");
        }
        catch (JMSException e) {
            LOGGER.log(Level.SEVERE, "Error occurred while creating session", e);
        }
    }

    private static String getTextMessage(PayaraNotification event) {
        String subject = event.getSubject();
        String message = event.getMessage();
        Object result = "";
        if (subject != null) {
            result = (String)result + subject;
        }
        if (message != null) {
            result = (String)result + "\n" + message;
        }
        return ((String)result).trim();
    }
}

