/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.handlers.RestUtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.xml.sax.SAXException;

public class TargetUtil {
    public static boolean isCluster(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getClusters().contains(name);
    }

    public static boolean isInstance(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getInstances().contains(name);
    }

    public static boolean isDeploymentGroup(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getDeploymentGroups().contains(name);
    }

    public static List<String> getStandaloneInstances() {
        List<String> result = new ArrayList<String>();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("standaloneonly", "true");
        attrsMap.put("nostatus", "true");
        try {
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, attrsMap, "get", null, false);
            Map dataMap = (Map)responseMap.get("data");
            Map extraProps = (Map)dataMap.get("extraProperties");
            if (extraProps == null) {
                return result;
            }
            List props = (List)extraProps.get("instanceList");
            if (props == null) {
                return result;
            }
            result = RestUtilHandlers.getListFromMapKey(props, new String[0]);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getStandaloneInstances ; \nendpoint = " + endpoint + ", attrsMap=" + attrsMap);
        }
        return result;
    }

    public static List<String> getDeploymentGroups() {
        ArrayList<String> dgs;
        block2: {
            dgs = new ArrayList<String>();
            try {
                dgs.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/deployment-groups/deployment-group").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getDeploymentGroups"), ex.getLocalizedMessage()});
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return dgs;
    }

    public static List<String> getClusters() {
        ArrayList<String> clusters;
        block2: {
            clusters = new ArrayList<String>();
            try {
                clusters.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getClusters"), ex.getLocalizedMessage()});
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return clusters;
    }

    public static List<String> getInstances() {
        ArrayList<String> instances;
        block2: {
            instances = new ArrayList<String>();
            try {
                instances.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getInstances"), ex.getLocalizedMessage()});
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return instances;
    }

    public static List<String> getConfigs() {
        ArrayList<String> config;
        block3: {
            config = new ArrayList<String>();
            try {
                config.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/configs/config").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getClusters"), ex.getLocalizedMessage()});
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
        if (config.isEmpty()) {
            GuiUtil.getLogger().warning("Detected Broken Session, forcing session reinitialisation");
            GuiUtil.setSessionValue("_SESSION_INITIALIZED", null);
        }
        return config;
    }

    public static List<String> getDGInstances(String dg) {
        ArrayList<String> instances = new ArrayList<String>();
        try {
            instances.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/deployment-groups/deployment-group/" + dg + "/dg-server-ref").keySet());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getMessage());
        }
        return instances;
    }

    public static List<String> getClusteredInstances(String cluster) {
        ArrayList<String> instances = new ArrayList<String>();
        try {
            instances.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + cluster + "/server-ref").keySet());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getMessage());
        }
        return instances;
    }

    public static String getTargetEndpoint(String target) {
        try {
            String encodedName = URLEncoder.encode(target, "UTF-8");
            Object endpoint = (String)GuiUtil.getSessionValue("REST_URL");
            if (target.equals("server")) {
                endpoint = (String)endpoint + "/servers/server/server";
            } else {
                List<String> clusters = TargetUtil.getClusters();
                List<String> dgs = TargetUtil.getDeploymentGroups();
                endpoint = clusters.contains(target) ? (String)endpoint + "/clusters/cluster/" + encodedName : (dgs.contains(target) ? (String)endpoint + "/deployment-groups/deployment-group/" + encodedName : (String)endpoint + "/servers/server/" + encodedName);
            }
            return endpoint;
        }
        catch (Exception ex) {
            GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getTargetEndpoint"), ex.getLocalizedMessage()});
            if (GuiUtil.getLogger().isLoggable(Level.FINE)) {
                ex.printStackTrace();
            }
            return "";
        }
    }

    public static String getConfigName(String target) {
        String endpoint;
        List<String> dgs = TargetUtil.getDeploymentGroups();
        if (dgs.contains(target)) {
            endpoint = (String)GuiUtil.getSessionValue("REST_URL");
            try {
                List<String> targets = RestUtil.getChildResourceList(endpoint + "/deployment-groups/deployment-group/" + target + "/dg-server-ref");
                if (targets.size() < 1) {
                    return "server-config";
                }
                target = targets.get(0);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(TargetUtil.class.getName()).log(Level.SEVERE, null, ex);
                return "server-config";
            }
        }
        endpoint = TargetUtil.getTargetEndpoint(target);
        return (String)RestUtil.getAttributesMap(endpoint).get("configRef");
    }

    public static Collection<String> getHostNames(String target) {
        HashSet<String> hostNames = new HashSet<String>();
        hostNames.toArray();
        List<String> clusters = TargetUtil.getClusters();
        List<Object> instances = new ArrayList<String>();
        if (clusters.contains(target)) {
            instances = TargetUtil.getClusteredInstances(target);
        } else {
            instances.add(target);
        }
        for (String string : instances) {
            String hostName = null;
            String ep = (String)GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + string;
            String node = (String)RestUtil.getAttributesMap(ep).get("nodeRef");
            if (node != null) {
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/nodes/node/" + node;
                hostName = (String)RestUtil.getAttributesMap(ep).get("nodeHost");
            }
            if (hostName == null) {
                hostName = "localhost";
            }
            hostNames.add(hostName);
        }
        return hostNames;
    }
}

