/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.osgi.BundleProvisioner;
import com.sun.enterprise.glassfish.bootstrap.osgi.Jar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class MinimalBundleProvisioner
extends BundleProvisioner {
    private Logger logger = LogFacade.BOOTSTRAP_LOGGER;
    private List<Long> installedBundleIds;

    public MinimalBundleProvisioner(BundleContext bundleContext, Properties config) {
        super(bundleContext, new MinimalCustomizer(config));
    }

    @Override
    public List<Long> installBundles() {
        List<Long> bundleIds;
        BundleContext bctx = this.getBundleContext();
        int n = bctx.getBundles().length;
        if (n > 1) {
            this.logger.logp(Level.FINE, "MinimalBundleProvisioner", "installBundles", "Skipping installation of bundles as there are already {0} no. of bundles.", new Object[]{n});
            bundleIds = Collections.emptyList();
        } else {
            bundleIds = super.installBundles();
        }
        this.installedBundleIds = bundleIds;
        return this.installedBundleIds;
    }

    @Override
    public void startBundles() {
        if (this.installedBundleIds.isEmpty()) {
            this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00032");
        } else {
            super.startBundles();
        }
    }

    @Override
    public boolean hasAnyThingChanged() {
        long latestBundleTimestamp = -1L;
        Bundle latestBundle = null;
        for (Bundle b : this.getBundleContext().getBundles()) {
            if (b.getLastModified() <= latestBundleTimestamp) continue;
            latestBundleTimestamp = b.getLastModified();
            latestBundle = b;
        }
        Jar latestJar = this.getCustomizer().getLatestJar();
        boolean changed = latestBundle != null && latestJar.getLastModified() > latestBundle.getLastModified();
        this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00033", new Object[]{changed, latestJar.getURI(), latestBundle != null ? latestBundle.getLocation() : "NULL"});
        return changed;
    }

    @Override
    public void refresh() {
        for (Bundle b : this.getBundleContext().getBundles()) {
            if (b.getBundleId() == 0L) continue;
            try {
                b.uninstall();
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
        this.installBundles();
        super.refresh();
        this.setSystemBundleUpdationRequired(true);
    }

    @Override
    public MinimalCustomizer getCustomizer() {
        return (MinimalCustomizer)super.getCustomizer();
    }

    static class MinimalCustomizer
    extends BundleProvisioner.DefaultCustomizer {
        private Logger logger = LogFacade.BOOTSTRAP_LOGGER;

        public MinimalCustomizer(Properties config) {
            super(config);
        }

        public Jar getLatestJar() {
            File latestFile = null;
            for (URI uri : this.getConfiguredAutoInstallLocations()) {
                File[] files;
                File file = null;
                try {
                    file = new File(uri);
                }
                catch (Exception e) {
                    continue;
                }
                if (latestFile == null) {
                    latestFile = file;
                }
                if (file.lastModified() > latestFile.lastModified()) {
                    latestFile = file;
                }
                if (!file.isDirectory() || (files = file.listFiles()) == null) continue;
                for (File child : files) {
                    if (child.lastModified() <= latestFile.lastModified()) continue;
                    latestFile = child;
                }
            }
            return latestFile != null ? new Jar(latestFile) : null;
        }

        @Override
        public List<URI> getAutoInstallLocations() {
            List<URI> installLocations = this.getAutoStartLocations();
            List<URI> fragments = this.selectFragmentJars(super.getAutoInstallLocations());
            installLocations.addAll(fragments);
            this.logger.log(Level.INFO, "NCLS-BOOTSTRAP-00030", new Object[]{installLocations});
            return installLocations;
        }

        private List<URI> selectFragmentJars(List<URI> installLocations) {
            ArrayList<URI> fragments = new ArrayList<URI>();
            for (URI uri : installLocations) {
                try {
                    InputStream is = uri.toURL().openStream();
                    try (JarInputStream jis = new JarInputStream(is);){
                        Manifest m = jis.getManifest();
                        if (m == null || m.getMainAttributes().getValue("Fragment-Host") == null) continue;
                        this.logger.logp(Level.FINE, "MinimalBundleProvisioner$MinimalCustomizer", "selectFragmentJars", "{0} is a fragment", new Object[]{uri});
                        fragments.add(uri);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    LogFacade.log(this.logger, Level.INFO, "NCLS-BOOTSTRAP-00031", e, uri);
                }
            }
            return fragments;
        }
    }
}

