/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.StringUtils;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-rest-monitoring-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=RestMonitoringConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-rest-monitoring-configuration", description="Gets the Rest Monitoring Configuration")})
public class GetRestMonitoringConfiguration
implements AdminCommand {
    private final String[] OUTPUT_HEADERS = new String[]{"Rest Monitoring Enabled", "Rest Monitoring Application Name", "Context Root", "Security Enabled"};
    @Inject
    private Target targetUtil;
    @Param(name="target", defaultValue="server", optional=true)
    private String target;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        ActionReport restMonitoringReport = actionReport.addSubActionsReport();
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            actionReport.setMessage("No such config name: " + this.targetUtil);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        RestMonitoringConfiguration restMonitoringConfiguration = (RestMonitoringConfiguration)config.getExtensionByType(RestMonitoringConfiguration.class);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.OUTPUT_HEADERS);
        Object[] outputValues = new Object[]{restMonitoringConfiguration.getEnabled(), restMonitoringConfiguration.getApplicationName(), restMonitoringConfiguration.getContextRoot(), restMonitoringConfiguration.getSecurityEnabled()};
        columnFormatter.addRow(outputValues);
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        extraPropertiesMap.put("enabled", restMonitoringConfiguration.getEnabled());
        extraPropertiesMap.put("applicationname", restMonitoringConfiguration.getApplicationName());
        extraPropertiesMap.put("contextroot", restMonitoringConfiguration.getContextRoot());
        extraPropertiesMap.put("securityenabled", restMonitoringConfiguration.getSecurityEnabled());
        Properties extraProperties = new Properties();
        extraProperties.put("restMonitoringConfiguration", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
        restMonitoringReport.setMessage(columnFormatter.toString());
        restMonitoringReport.appendMessage(StringUtils.EOL);
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

