/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service.security;

import com.sun.enterprise.security.SecurityServicesUtil;
import fish.payara.appserver.monitoring.rest.service.configuration.RestMonitoringConfiguration;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.hk2.api.ServiceLocator;

public class RestMonitoringAuthModule
implements ServerAuthModule {
    private String contextRoot = null;
    private CallbackHandler handler = null;
    private boolean securityEnabled = false;
    private static final String DEFAULT_USER_NAME = "payara";
    private static final String ORIG_REQUEST_PATH = "origRequestPath";
    private static final String LOGIN_PAGE = "/login.xhtml";
    private static final Class[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        ServiceLocator habitat = SecurityServicesUtil.getInstance().getHabitat();
        RestMonitoringConfiguration restMonitoringConfiguration = (RestMonitoringConfiguration)habitat.getService(RestMonitoringConfiguration.class, new Annotation[0]);
        this.contextRoot = restMonitoringConfiguration.getContextRoot();
        this.securityEnabled = Boolean.parseBoolean(restMonitoringConfiguration.getSecurityEnabled());
    }

    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        if (this.securityEnabled) {
            HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
            HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
            HttpSession session = request.getSession();
            Principal userPrincipal = request.getUserPrincipal();
            if (userPrincipal != null) {
                try {
                    this.handler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, userPrincipal)});
                    return AuthStatus.SUCCESS;
                }
                catch (IOException | UnsupportedCallbackException ex) {
                    AuthException ae = new AuthException();
                    ae.initCause((Throwable)ex);
                    throw ae;
                }
            }
            String username = request.getParameter("j_username");
            String password = request.getParameter("j_password");
            if (username == null || password == null || !request.getMethod().equalsIgnoreCase("post")) {
                Object origPath = request.getRequestURI();
                String queryString = request.getQueryString();
                if (queryString != null && !queryString.isEmpty()) {
                    origPath = (String)origPath + "?" + queryString;
                }
                session.setAttribute(ORIG_REQUEST_PATH, origPath);
                RequestDispatcher rd = request.getRequestDispatcher(LOGIN_PAGE);
                try {
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception ex) {
                    AuthException authException = new AuthException();
                    authException.initCause((Throwable)ex);
                    throw authException;
                }
                return AuthStatus.SEND_CONTINUE;
            }
            PasswordValidationCallback pvCallback = new PasswordValidationCallback(clientSubject, username, password.toCharArray());
            try {
                this.handler.handle(new Callback[]{pvCallback});
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause((Throwable)ex);
                throw ae;
            }
            messageInfo.getMap().put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
            try {
                String origRequest = (String)session.getAttribute(ORIG_REQUEST_PATH);
                if (origRequest == null) {
                    origRequest = this.contextRoot;
                }
                response.sendRedirect(response.encodeRedirectURL(origRequest));
            }
            catch (Exception ex) {
                AuthException ae = new AuthException();
                ae.initCause((Throwable)ex);
                throw ae;
            }
            return AuthStatus.SUCCESS;
        }
        Callback[] callbacks = new Callback[]{new CallerPrincipalCallback(clientSubject, DEFAULT_USER_NAME)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException ex) {
            Logger.getLogger(RestMonitoringAuthModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        return AuthStatus.SUCCESS;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        if (subject != null) {
            subject.getPrincipals().clear();
        }
    }
}

