/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.custom.factory;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class PrimitivesAndStringFactory
implements Serializable,
ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> refAddrs = ref.getAll();
        String type = null;
        String value = null;
        boolean hasAnyProperties = false;
        while (refAddrs.hasMoreElements()) {
            hasAnyProperties = true;
            RefAddr addr = refAddrs.nextElement();
            String propName = addr.getType();
            type = ref.getClassName();
            if (!propName.equalsIgnoreCase("value")) continue;
            value = (String)addr.getContent();
        }
        if (!hasAnyProperties && type == null) {
            type = ref.getClassName();
        }
        if (type != null && value != null) {
            if ((type = type.toUpperCase(Locale.getDefault())).endsWith("INT") || type.endsWith("INTEGER")) {
                return Integer.valueOf(value);
            }
            if (type.endsWith("LONG")) {
                return Long.valueOf(value);
            }
            if (type.endsWith("DOUBLE")) {
                return Double.valueOf(value);
            }
            if (type.endsWith("FLOAT")) {
                return Float.valueOf(value);
            }
            if (type.endsWith("CHAR") || type.endsWith("CHARACTER")) {
                return Character.valueOf(value.charAt(0));
            }
            if (type.endsWith("SHORT")) {
                return Short.valueOf(value);
            }
            if (type.endsWith("BYTE")) {
                return Byte.valueOf(value);
            }
            if (type.endsWith("BOOLEAN")) {
                return Boolean.valueOf(value);
            }
            if (type.endsWith("STRING")) {
                return value;
            }
            throw new IllegalArgumentException("unknown type [" + type + "] ");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        throw new IllegalAccessException("value cannot be null");
    }
}

