/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.JwtPrivateKeyStore;
import fish.payara.microprofile.jwtauth.eesecurity.JwtPublicKeyStore;
import fish.payara.microprofile.jwtauth.eesecurity.SignedJWTCredential;
import fish.payara.microprofile.jwtauth.jwt.JsonWebTokenImpl;
import fish.payara.microprofile.jwtauth.jwt.JwtTokenParser;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class SignedJWTIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(SignedJWTIdentityStore.class.getName());
    private final String acceptedIssuer;
    private final Optional<List<String>> allowedAudience;
    private final Optional<Boolean> enabledNamespace;
    private final Optional<String> customNamespace;
    private final Optional<Boolean> disableTypeVerification;
    private final Config config = ConfigProvider.getConfig();
    private final JwtPublicKeyStore publicKeyStore;
    private final JwtPrivateKeyStore privateKeyStore;
    private final boolean isEncryptionRequired;
    private Map<String, Optional<String>> optionalConfigProperty;

    public SignedJWTIdentityStore() {
        Optional<Properties> properties = SignedJWTIdentityStore.readVendorProperties();
        this.acceptedIssuer = this.readVendorIssuer(properties).orElseGet(() -> (String)this.config.getOptionalValue("mp.jwt.verify.issuer", String.class).orElseThrow(() -> new IllegalStateException("No issuer found")));
        Optional allowedAudienceOpt = this.readAudience(properties);
        if (!allowedAudienceOpt.isPresent()) {
            allowedAudienceOpt = this.config.getOptionalValue("mp.jwt.verify.audiences", String.class);
        }
        this.allowedAudience = allowedAudienceOpt.map(str -> Arrays.asList(str.split(",")));
        this.enabledNamespace = this.readEnabledNamespace(properties);
        this.customNamespace = this.readCustomNamespace(properties);
        this.disableTypeVerification = this.readDisableTypeVerification(properties);
        Optional<String> publicKeyLocation = SignedJWTIdentityStore.readConfigOptional("mp.jwt.verify.publickey.location", properties, this.config);
        Optional<String> publicKey = SignedJWTIdentityStore.readConfigOptional("mp.jwt.verify.publickey", properties, this.config);
        Optional<String> decryptKeyLocation = SignedJWTIdentityStore.readConfigOptional("mp.jwt.decrypt.key.location", properties, this.config);
        this.publicKeyStore = new JwtPublicKeyStore(this.readPublicKeyCacheTTL(properties), publicKeyLocation);
        this.privateKeyStore = new JwtPrivateKeyStore(this.readPublicKeyCacheTTL(properties), decryptKeyLocation);
        this.isEncryptionRequired = decryptKeyLocation.isPresent();
        this.setOptionalConfigProperty(properties);
    }

    public CredentialValidationResult validate(SignedJWTCredential signedJWTCredential) {
        JwtTokenParser jwtTokenParser = new JwtTokenParser(this.enabledNamespace, this.customNamespace, this.disableTypeVerification);
        try {
            JsonWebTokenImpl jsonWebToken = jwtTokenParser.parse(signedJWTCredential.getSignedJWT(), this.isEncryptionRequired, this.publicKeyStore, this.acceptedIssuer, this.privateKeyStore, this.optionalConfigProperty);
            Set recipientsOfThisJWT = jsonWebToken.getAudience();
            Boolean recipientInAudience = this.allowedAudience.map(recipient -> recipient.stream().anyMatch(a -> recipientsOfThisJWT != null && recipientsOfThisJWT.contains(a))).orElse(true);
            if (!recipientInAudience.booleanValue()) {
                throw new Exception("The intended audience " + recipientsOfThisJWT + " is not a part of allowed audience.");
            }
            HashSet groups = new HashSet();
            Collection groupClaims = (Collection)jsonWebToken.getClaim("groups");
            if (groupClaims != null) {
                groups.addAll(groupClaims);
            }
            return new CredentialValidationResult((CallerPrincipal)jsonWebToken, groups);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception trying to parse JWT token.", e);
            return CredentialValidationResult.INVALID_RESULT;
        }
    }

    public static Optional<Properties> readVendorProperties() {
        URL mpJwtResource = Thread.currentThread().getContextClassLoader().getResource("/payara-mp-jwt.properties");
        Properties properties = null;
        if (mpJwtResource != null) {
            try {
                properties = new Properties();
                properties.load(mpJwtResource.openStream());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load Vendor properties from resource file", e);
            }
        }
        return Optional.ofNullable(properties);
    }

    private Optional<String> readVendorIssuer(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("accepted.issuer")) : Optional.empty();
    }

    private Optional<Boolean> readEnabledNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(Boolean.valueOf(properties.get().getProperty("enable.namespace", "false"))) : Optional.empty();
    }

    private Optional<String> readCustomNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("custom.namespace", null)) : Optional.empty();
    }

    private Optional<Boolean> readDisableTypeVerification(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(Boolean.valueOf(properties.get().getProperty("disable.type.verification", "false"))) : Optional.empty();
    }

    private Duration readPublicKeyCacheTTL(Optional<Properties> properties) {
        return properties.map(props -> props.getProperty("publicKey.cache.ttl")).map(Long::valueOf).map(Duration::ofMillis).orElseGet(() -> Duration.ofMinutes(5L));
    }

    private Optional<String> readAudience(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("mp.jwt.verify.audiences")) : Optional.empty();
    }

    public static String readConfig(String key, Optional<Properties> properties, Config config, String defaultValue) {
        Optional<String> valueOpt = SignedJWTIdentityStore.readConfigOptional(key, properties, config);
        return valueOpt.orElse(defaultValue);
    }

    public static Optional<String> readConfigOptional(String key, Optional<Properties> properties, Config config) {
        Optional valueOpt = properties.map(props -> props.getProperty(key));
        if (!valueOpt.isPresent()) {
            valueOpt = config.getOptionalValue(key, String.class);
        }
        return valueOpt;
    }

    private void setOptionalConfigProperty(Optional<Properties> properties) {
        this.optionalConfigProperty = new HashMap<String, Optional<String>>();
        this.optionalConfigProperty.put("mp.jwt.verify.token.age", SignedJWTIdentityStore.readConfigOptional("mp.jwt.verify.token.age", properties, this.config));
        this.optionalConfigProperty.put("mp.jwt.verify.clock.skew", SignedJWTIdentityStore.readConfigOptional("mp.jwt.verify.clock.skew", properties, this.config));
        this.optionalConfigProperty.put("mp.jwt.decrypt.key.algorithm", SignedJWTIdentityStore.readConfigOptional("mp.jwt.decrypt.key.algorithm", properties, this.config));
    }
}

