/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification;

import java.util.function.BiPredicate;
import java.util.logging.Level;

public enum EventLevel {
    INFO(800),
    WARNING(900),
    SEVERE(1000);

    private final int severityLevel;

    public static EventLevel fromNameOrWarning(String name) {
        try {
            return EventLevel.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return WARNING;
        }
    }

    public static EventLevel fromLogLevel(Level level) {
        if (level.intValue() <= EventLevel.INFO.severityLevel) {
            return INFO;
        }
        if (level.intValue() <= EventLevel.WARNING.severityLevel) {
            return WARNING;
        }
        return SEVERE;
    }

    private EventLevel(int severityLevel) {
        this.severityLevel = severityLevel;
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public boolean compare(EventLevel other, BiPredicate<Integer, Integer> predicate) {
        return predicate.test(this.severityLevel, other.severityLevel);
    }
}

