/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import fish.payara.internal.notification.admin.NotificationServiceConfiguration;
import jakarta.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;

public abstract class BaseGetNotifierConfigurationCommand<C extends PayaraNotifierConfiguration>
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    protected ServiceLocator habitat;
    private Class<C> notifierConfigurationClass;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport mainActionReport = context.getActionReport();
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.notifierConfigurationClass = (Class)genericSuperclass.getActualTypeArguments()[0];
        NotificationServiceConfiguration configuration = (NotificationServiceConfiguration)config.getExtensionByType(NotificationServiceConfiguration.class);
        C nc = configuration.getNotifierConfigurationByType(this.notifierConfigurationClass);
        Properties extraProps = new Properties();
        Map<String, Object> configMap = this.getNotifierProperties(nc);
        String message = nc == null ? "Notifier Configuration is not defined" : this.listConfiguration(nc);
        mainActionReport.setMessage(message);
        extraProps.put("notifierConfiguration", configMap);
        mainActionReport.setExtraProperties(extraProps);
        mainActionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    protected String listConfiguration(C configuration) {
        Map<String, Object> configMap = this.getNotifierConfiguration(configuration);
        Iterator<Map.Entry<String, Object>> configIterator = configMap.entrySet().iterator();
        ArrayList<String> headers = new ArrayList<String>(2);
        ArrayList<Object> values = new ArrayList<Object>(2);
        while (configIterator.hasNext()) {
            Map.Entry<String, Object> entry = configIterator.next();
            headers.add(entry.getKey());
            values.add(entry.getValue());
        }
        ColumnFormatter columnFormatter = new ColumnFormatter(headers.toArray(new String[0]));
        columnFormatter.addRow(values.toArray());
        return columnFormatter.toString();
    }

    protected Map<String, Object> getNotifierConfiguration(C configuration) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        if (configuration != null) {
            map.put("Enabled", configuration.getEnabled());
            map.put("Filter", configuration.getFilter());
        } else {
            map.put("Enabled", Boolean.FALSE.toString());
            map.put("Filter", EventLevel.WARNING.toString());
        }
        return map;
    }

    protected Map<String, Object> getNotifierProperties(C configuration) {
        Map<String, Object> configMap = this.getNotifierConfiguration(configuration);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            result.put(NotifierUtils.convertToCamelCase(entry.getKey()), entry.getValue());
        }
        return result;
    }
}

