/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.activation;

import fish.payara.microprofile.connector.MicroProfileSniffer;
import fish.payara.microprofile.metrics.activation.MetricsContainer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class MetricsSniffer
extends MicroProfileSniffer {
    private static final Logger LOGGER = Logger.getLogger(MetricsSniffer.class.getName());
    @Inject
    private ServerEnvironment serverEnv;

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[]{Counted.class, Gauge.class, Metric.class, Timed.class, RegistryType.class, RegistryScope.class, Path.class};
    }

    public boolean handles(DeploymentContext context) {
        Types types = (Types)context.getTransientAppMetaData(Types.class.getName(), Types.class);
        if (types != null) {
            if (types.getBy(MetricRegistry.class.getName()) != null) {
                return true;
            }
            if (types.getBy(org.eclipse.microprofile.metrics.Metric.class.getName()) != null) {
                return true;
            }
        }
        return super.handles(context);
    }

    public boolean handles(ReadableArchive archive) {
        try {
            if (archive.exists("metrics.xml")) {
                return true;
            }
            File metricsResource = new File(this.serverEnv.getConfigDirPath(), "metrics.xml");
            if (metricsResource.exists()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading archive", e);
            return false;
        }
        return super.handles(archive);
    }

    protected Class<?> getContainersClass() {
        return MetricsContainer.class;
    }

    public String getModuleType() {
        return "metrics";
    }
}

