/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.microprofile.SetSecureMicroprofileConfigurationCommand;
import fish.payara.microprofile.metrics.admin.MetricsServiceConfiguration;
import fish.payara.microprofile.metrics.impl.MetricsServiceImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.Target;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-metrics-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MetricsServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-metrics-configuration", description="Sets the Metrics Configuration")})
public class SetMetricsConfigurationCommand
extends SetSecureMicroprofileConfigurationCommand {
    private static final Logger LOGGER = Logger.getLogger(SetMetricsConfigurationCommand.class.getName());
    @Inject
    private Target targetUtil;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Deprecated
    @Param(name="secureMetrics", optional=true)
    private Boolean secure;
    @Param(name="dynamic", optional=true)
    private Boolean dynamic;
    @Param(name="endpoint", optional=true)
    private String endpoint;
    @Param(name="virtualServers", optional=true)
    private String virtualServers;
    @Inject
    private Domain domain;
    @Inject
    UnprocessedConfigListener unprocessedListener;
    @Inject
    ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Subject subject = context.getSubject();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        MetricsServiceConfiguration metricsConfiguration = (MetricsServiceConfiguration)targetConfig.getExtensionByType(MetricsServiceConfiguration.class);
        MetricsServiceImpl metricsService = (MetricsServiceImpl)Globals.getDefaultBaseServiceLocator().getService(MetricsServiceImpl.class, new Annotation[0]);
        if (Boolean.TRUE.equals(this.securityEnabled) || Boolean.parseBoolean(metricsConfiguration.getSecurityEnabled())) {
            ActionReport checkUserReport = actionReport.addSubActionsReport();
            ActionReport createUserReport = actionReport.addSubActionsReport();
            if (!this.defaultMicroprofileUserExists(checkUserReport, subject) && !checkUserReport.hasFailures()) {
                this.createDefaultMicroprofileUser(createUserReport, subject);
            }
            if (checkUserReport.hasFailures() || createUserReport.hasFailures()) {
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.dynamic != null) {
                    configProxy.setDynamic(this.dynamic.toString());
                }
                if (this.enabled != null) {
                    configProxy.setEnabled(this.enabled.toString());
                    if (this.dynamic != null && this.dynamic.booleanValue() || Boolean.valueOf(metricsConfiguration.getDynamic()).booleanValue()) {
                        metricsService.resetMetricsEnabledProperty();
                    }
                }
                if (this.secure != null) {
                    actionReport.setMessage("--secureMetrics option is deprecated, replaced by --securityEnabled option.");
                    configProxy.setSecureMetrics(this.secure.toString());
                    if (this.dynamic != null && this.dynamic.booleanValue() || Boolean.valueOf(metricsConfiguration.getDynamic()).booleanValue()) {
                        metricsService.resetMetricsSecureProperty();
                    }
                }
                if (this.endpoint != null) {
                    configProxy.setEndpoint(this.endpoint);
                }
                if (this.virtualServers != null) {
                    configProxy.setVirtualServers(this.virtualServers);
                }
                if (this.securityEnabled != null) {
                    configProxy.setSecurityEnabled(this.securityEnabled.toString());
                }
                if (this.roles != null) {
                    configProxy.setRoles(this.roles);
                }
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return configProxy;
            }, (ConfigBeanProxy)metricsConfiguration);
            if (metricsConfiguration != null && !Boolean.valueOf(metricsConfiguration.getDynamic()).booleanValue()) {
                actionReport.setMessage("Restart server for change to take effect");
            }
        }
        catch (TransactionFailure ex) {
            actionReport.failure(LOGGER, "Failed to update Metrics configuration", (Throwable)ex);
        }
        if (!actionReport.hasFailures() && !actionReport.hasWarnings()) {
            actionReport.getSubActionsReport().clear();
        }
    }
}

