/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi;

import fish.payara.microprofile.metrics.cdi.MetricUtils;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;

public final class AnnotationReader<T extends Annotation> {
    private static final Map<Class<? extends Annotation>, AnnotationReader<?>> READERS_BY_ANNOTATION = new HashMap();
    public static final AnnotationReader<Counted> COUNTED = new AnnotationReader<Counted>(Counted.class, Counted.class.getName(), Counted::name, Counted::tags, Counted::description, Counted::absolute, Counted::unit, Counted::scope);
    public static final AnnotationReader<Gauge> GAUGE = new AnnotationReader<Gauge>(Gauge.class, Gauge.class.getName(), Gauge::name, Gauge::tags, Gauge::description, Gauge::absolute, Gauge::unit, Gauge::scope);
    public static final AnnotationReader<Timed> TIMED = new AnnotationReader<Timed>(Timed.class, Timed.class.getName(), Timed::name, Timed::tags, Timed::description, Timed::absolute, Timed::unit, Timed::scope);
    public static final AnnotationReader<Metric> METRIC = new AnnotationReader<Metric>(Metric.class, Metric.class.getName(), Metric::name, Metric::tags, Metric::description, Metric::absolute, Metric::unit, Metric::scope);
    private final Class<T> annotationType;
    private final String nameType;
    private final Function<T, String> name;
    private final Function<T, String[]> tags;
    private final Function<T, String> description;
    private final Predicate<T> absolute;
    private final Function<T, String> unit;
    private final Function<T, String> scope;

    public static <T extends Annotation> AnnotationReader<T> forAnnotation(Class<T> annotationType) {
        AnnotationReader<?> reader = READERS_BY_ANNOTATION.get(annotationType);
        if (reader == null) {
            throw new IllegalArgumentException("Unsupported Metrics [" + annotationType.getName() + "]");
        }
        return reader;
    }

    public static Iterable<AnnotationReader<?>> readers() {
        return READERS_BY_ANNOTATION.values();
    }

    private static void register(AnnotationReader<?> reader) {
        READERS_BY_ANNOTATION.put(reader.annotationType(), reader);
    }

    private AnnotationReader(Class<T> annotationType, String nameType, Function<T, String> name, Function<T, String[]> tags, Function<T, String> description, Predicate<T> absolute, Function<T, String> unit, Function<T, String> scope) {
        this.annotationType = annotationType;
        this.nameType = nameType;
        this.name = name;
        this.tags = tags;
        this.description = description;
        this.absolute = absolute;
        this.unit = unit;
        this.scope = scope;
    }

    public Class<T> annotationType() {
        return this.annotationType;
    }

    public AnnotationReader<T> asType(String nameType) {
        if (this.annotationType != Metric.class) {
            throw new IllegalStateException("Only Metric reader can be typed!");
        }
        return new AnnotationReader<T>(this.annotationType, nameType, this.name, this.tags, this.description, this.absolute, this.unit, this.scope);
    }

    private AnnotationReader<T> asType(Type genericType) {
        Class type = (Class)(genericType instanceof Class ? genericType : ((ParameterizedType)genericType).getRawType());
        return this.asType(type.getName());
    }

    private AnnotationReader<T> asAutoType(Type genericType) {
        return this.annotationType == Metric.class ? this.asType(genericType) : this;
    }

    public <E extends Member & AnnotatedElement> T annotation(Class<?> bean, E element) {
        try {
            return (T)((Annotation)this.compute(bean, element, (Function<T, R>)Function.identity(), Function.identity()));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public T annotation(InjectionPoint point) {
        return (T)this.compute(point, (T annotation, String name) -> annotation);
    }

    public <E extends Member & AnnotatedElement> boolean isPresent(Class<?> bean, E element) {
        return this.nameType == AnnotationReader.GAUGE.nameType ? element instanceof Method && ((AnnotatedElement)element).isAnnotationPresent(this.annotationType) : this.annotation(bean, element) != null;
    }

    public String name(T annotation) {
        return this.name.apply(annotation);
    }

    public String name(InjectionPoint point) {
        return this.compute(point, this::name);
    }

    public String name(AnnotatedMember<?> member) {
        return this.compute(member, this::name);
    }

    public <E extends Member & AnnotatedElement> String name(Class<?> bean, E element) {
        return this.compute(bean, element, (BiFunction<T, String, R>)((BiFunction<Annotation, String, String>)this::name));
    }

    private String name(T annotation, String name) {
        return name;
    }

    public Tag[] tags(T annotation) {
        return AnnotationReader.tagsFromString(this.tags.apply(annotation));
    }

    public MetricID metricID(T annotation) {
        return new MetricID(this.name(annotation), this.tags(annotation));
    }

    public MetricID metricID(InjectionPoint point) {
        return this.compute(point, this::metricID);
    }

    public MetricID metricID(AnnotatedMember<?> member) {
        return this.compute(member, this::metricID);
    }

    public <E extends Member & AnnotatedElement> MetricID metricID(Class<?> bean, E element) {
        return this.compute(bean, element, (BiFunction<T, String, R>)((BiFunction<Annotation, String, MetricID>)this::metricID));
    }

    private MetricID metricID(T annotation, String name) {
        return new MetricID(name, this.tags(annotation));
    }

    public String description(T annotation) {
        return this.description.apply(annotation);
    }

    public String unit(T annotation) {
        return this.unit.apply(annotation);
    }

    public String scope(T annotation) {
        return this.scope.apply(annotation);
    }

    public boolean absolute(T annotation) {
        return this.absolute.test(annotation);
    }

    public Metadata metadata(T annotation) {
        return this.metadata(annotation, this.name(annotation));
    }

    public Metadata metadata(InjectionPoint point) {
        AnnotationReader<Annotation> reader = this.asAutoType(point.getType());
        return reader.compute(point, reader::metadata);
    }

    public Metadata metadata(AnnotatedMember<?> member) {
        AnnotationReader<Annotation> reader = this.asAutoType(member.getBaseType());
        return reader.compute(member, reader::metadata);
    }

    public <E extends Member & AnnotatedElement> Metadata metadata(Class<?> bean, E element) {
        AnnotationReader<Annotation> reader = this;
        if (element instanceof Method) {
            reader = this.asAutoType(((Method)element).getGenericReturnType());
        } else if (element instanceof Field) {
            reader = this.asAutoType(((Field)element).getGenericType());
        }
        return reader.compute(bean, element, (BiFunction<Annotation, String, R>)((BiFunction<Annotation, String, Metadata>)reader::metadata));
    }

    private Metadata metadata(T annotation, String name) {
        return Metadata.builder().withName(name).withDescription(this.description(annotation)).withUnit(this.unit(annotation)).build();
    }

    public boolean equals(Object obj) {
        return obj instanceof AnnotationReader && this.annotationType == ((AnnotationReader)obj).annotationType;
    }

    public int hashCode() {
        return this.annotationType.hashCode();
    }

    public String toString() {
        return this.annotationType.toString();
    }

    public boolean isReference(T annotation) {
        return this.unit(annotation).equals("none") && this.description(annotation).isEmpty();
    }

    public <M extends org.eclipse.microprofile.metrics.Metric> M getOrRegister(InjectionPoint point, Class<M> metric, MetricRegistry registry) {
        T annotation = null;
        try {
            annotation = this.annotation(point);
        }
        catch (IllegalArgumentException ex) {
            String name = MetricRegistry.name(point.getMember().getDeclaringClass().getCanonicalName(), AnnotationReader.localName(point.getMember()));
            return MetricUtils.getOrRegisterByName(registry, metric, name);
        }
        if (this.isReference(annotation)) {
            return MetricUtils.getOrRegisterByNameAndTags(registry, metric, this.name(point), this.tags(annotation));
        }
        return MetricUtils.getOrRegisterByMetadataAndTags(registry, metric, this.metadata(point), this.tags(annotation));
    }

    private <R> R compute(InjectionPoint point, BiFunction<T, String, R> func) {
        Annotated annotated = point.getAnnotated();
        if (annotated instanceof AnnotatedMember) {
            return this.compute((AnnotatedMember)annotated, func);
        }
        if (annotated instanceof AnnotatedParameter) {
            return this.compute(point, (AnnotatedParameter)annotated, func);
        }
        throw new IllegalArgumentException("Unable to retrieve data for injection point [" + point + "], only members and parameters are supported");
    }

    private <R> R compute(InjectionPoint point, AnnotatedParameter<?> parameter, BiFunction<T, String, R> func) {
        Executable annotated = (Executable)point.getMember();
        MemberParameter member = new MemberParameter(annotated.getParameters()[parameter.getPosition()]);
        return this.compute(member.getDeclaringClass(), member, arg_0 -> parameter.getAnnotation(arg_0), func);
    }

    private <R> R compute(AnnotatedMember<?> member, BiFunction<T, String, R> func) {
        Member jmember = member.getJavaMember();
        return this.compute(jmember.getDeclaringClass(), jmember, arg_0 -> member.getAnnotation(arg_0), func);
    }

    private <E extends AnnotatedElement & Member, R> R compute(Class<?> bean, E element, BiFunction<T, String, R> func) {
        return this.compute(bean, (Member)element, element::getAnnotation, func);
    }

    private <R> R compute(Class<?> bean, Member member, Function<Class<T>, T> element, BiFunction<T, String, R> func) {
        return (R)this.compute(bean, member, element, annotation -> func.apply(annotation, this.namedOnElementLevel(annotation, member)), annotation -> func.apply(annotation, this.namedOnClassLevel(annotation, bean, member)));
    }

    private <E extends AnnotatedElement & Member, R> R compute(Class<?> bean, E element, Function<T, R> onElement, Function<T, R> onClass) {
        return this.compute(bean, element, element::getAnnotation, onElement, onClass);
    }

    private <R> R compute(Class<?> bean, Member member, Function<Class<T>, T> element, Function<T, R> onElement, Function<T, R> onClass) {
        Annotation annotation = (Annotation)element.apply(this.annotationType);
        if (annotation != null) {
            return onElement.apply(annotation);
        }
        if (bean.isAnnotationPresent(this.annotationType)) {
            return onClass.apply(bean.getAnnotation(this.annotationType));
        }
        for (Annotation a : bean.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(Stereotype.class) || !a.annotationType().isAnnotationPresent(this.annotationType)) continue;
            return onClass.apply(a.annotationType().getAnnotation(this.annotationType));
        }
        if (bean.getSuperclass() != null) {
            return this.compute(bean.getSuperclass(), member, element, onElement, onClass);
        }
        throw this.illegal(bean, member);
    }

    private String namedOnElementLevel(T annotation, Member member) {
        String localName = this.name(annotation);
        if (localName.isEmpty()) {
            localName = AnnotationReader.localName(member);
        }
        return this.absolute(annotation) ? localName : MetricRegistry.name(member.getDeclaringClass().getCanonicalName(), localName);
    }

    private String namedOnClassLevel(T annotation, Class<?> bean, Member member) {
        String context = this.name(annotation);
        if (context.isEmpty()) {
            context = this.absolute(annotation) ? bean.getSimpleName() : bean.getCanonicalName();
        } else if (!this.absolute(annotation)) {
            context = MetricRegistry.name(bean.getPackage().getName(), context);
        }
        return MetricRegistry.name(context, AnnotationReader.localName(member));
    }

    private static String localName(Member member) {
        return member instanceof Constructor ? member.getDeclaringClass().getSimpleName() : member.getName();
    }

    private IllegalArgumentException illegal(Class<?> bean, Member member) {
        return new IllegalArgumentException("Neither given member " + member + "nor the given bean " + bean + " are annotated with " + this.annotationType);
    }

    public static Tag[] tagsFromString(String[] tags) {
        if (tags == null || tags.length == 0) {
            return new Tag[0];
        }
        return (Tag[])Arrays.asList(tags).stream().map(AnnotationReader::tagFromString).toArray(Tag[]::new);
    }

    private static Tag tagFromString(String tag) {
        int splitIndex = tag.indexOf(61);
        if (splitIndex == -1) {
            throw new IllegalArgumentException("invalid tag: " + tag + ", tags must be in the form key=value");
        }
        return new Tag(tag.substring(0, splitIndex), tag.substring(splitIndex + 1));
    }

    static {
        AnnotationReader.register(COUNTED);
        AnnotationReader.register(GAUGE);
        AnnotationReader.register(TIMED);
        AnnotationReader.register(METRIC);
    }

    private static final class MemberParameter
    implements Member {
        private final Parameter param;

        MemberParameter(Parameter param) {
            this.param = param;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.param.getDeclaringExecutable().getDeclaringClass();
        }

        @Override
        public String getName() {
            return this.param.getName();
        }

        @Override
        public int getModifiers() {
            return this.param.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.param.isSynthetic();
        }

        public String toString() {
            return this.param.toString();
        }
    }
}

