/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.rest;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.MetricUtils;
import fish.payara.microprofile.metrics.exception.NoSuchMetricException;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.writer.MetricsWriter;
import fish.payara.microprofile.metrics.writer.MetricsWriterImpl;
import fish.payara.microprofile.metrics.writer.OpenMetricsExporter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.glassfish.internal.api.Globals;

public class MetricsResource
extends HttpServlet {
    private static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    private static final Logger LOG = Logger.getLogger(MetricsResource.class.getName());
    private static final String APPLICATION_WILDCARD = "application/*";
    private static final Pattern PATTERN_Q_PART = Pattern.compile("\\s*q\\s*=\\s*(.+)");

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block14: {
            MetricsService metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
            if (!metricsService.isEnabled()) {
                response.sendError(403, "MicroProfile Metrics Service is disabled");
                return;
            }
            metricsService.refresh();
            String scopeParameter = request.getParameter("scope") != null ? request.getParameter("scope") : null;
            String metricName = request.getParameter("name") != null ? request.getParameter("name") : null;
            String pathInfo = request.getPathInfo() != null ? request.getPathInfo().substring(1) : "";
            String[] pathInfos = pathInfo.split("/");
            boolean availableScope = true;
            if (!pathInfo.isEmpty() && pathInfos.length > 0) {
                response.sendError(404, "Not available paths to consume");
                return;
            }
            try {
                String contentType = MetricsResource.getContentType(request, response);
                if (contentType == null) break block14;
                response.setContentType(contentType);
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                MetricsWriter outputWriter = MetricsResource.getOutputWriter(request, response, metricsService, contentType);
                if (outputWriter == null) break block14;
                if (scopeParameter != null && !scopeParameter.isEmpty()) {
                    String scope;
                    try {
                        scope = scopeParameter.equals("base") ? "base" : (scopeParameter.equals("vendor") ? "vendor" : (scopeParameter.equals("application") ? "application" : scopeParameter));
                    }
                    catch (RuntimeException ex) {
                        throw new NoSuchRegistryException(scopeParameter);
                    }
                    for (String name : metricsService.getContextNames()) {
                        Optional<String> availableScopeOptional = metricsService.getContext(name).getRegistries().keySet().stream().filter(k -> k.equals(scope)).findAny();
                        if (!availableScopeOptional.isPresent()) {
                            availableScope = false;
                            continue;
                        }
                        availableScope = true;
                    }
                    if (!availableScope) {
                        response.sendError(404, "Not available scope to consume");
                    }
                    if (availableScope && scope != null && metricName != null) {
                        outputWriter.write(scope, metricName);
                    } else if (availableScope) {
                        outputWriter.write(scope);
                    }
                    break block14;
                }
                outputWriter.write();
            }
            catch (NoSuchRegistryException ex) {
                response.sendError(404, String.format("[%s] registry not found", scopeParameter));
            }
            catch (NoSuchMetricException ex) {
                response.sendError(404, String.format("[%s] metric not found", metricName));
            }
        }
    }

    private static MetricsWriter getOutputWriter(HttpServletRequest request, HttpServletResponse response, MetricsService service, String contentType) throws IOException {
        PrintWriter writer = response.getWriter();
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) && "text/plain".equals(contentType)) {
            return new MetricsWriterImpl(new OpenMetricsExporter(writer), service.getContextNames(), service::getContext, MetricUtils.resolveGlobalTagsConfiguration());
        }
        return null;
    }

    private static String getContentType(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        String accept = request.getHeader("Accept");
        if (accept == null) {
            accept = "text/plain";
        }
        switch (method) {
            case "GET": {
                Optional<String> selectedFormat = MetricsResource.parseMetricsAcceptHeader(accept);
                if (selectedFormat.isPresent()) {
                    return selectedFormat.get();
                }
                response.sendError(406, String.format("[%s] not acceptable", accept));
                return null;
            }
        }
        response.sendError(405, String.format("HTTP method [%s] not allowed", method));
        return null;
    }

    static Optional<String> parseMetricsAcceptHeader(String accept) {
        String[] acceptFormats = accept.split(",");
        double qTextFormat = 0.0;
        for (String format : acceptFormats) {
            if (!format.contains("text/plain") && !format.contains("*/*") && !format.contains("text/*")) continue;
            qTextFormat = MetricsResource.parseQValue(format);
        }
        if (qTextFormat == 0.0) {
            return Optional.empty();
        }
        return Optional.of("text/plain");
    }

    private static double parseQValue(String format) {
        return Stream.of(format.split(";")).skip(1L).map(PATTERN_Q_PART::matcher).filter(Matcher::find).mapToDouble(m -> MetricsResource.toDouble(m.group(1))).findFirst().orElse(1.0);
    }

    private static double toDouble(String text) {
        try {
            if (text.startsWith(".")) {
                return Double.parseDouble("0" + text);
            }
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            LOG.warning(() -> "Invalid q value in Accept header: " + text);
            return 0.0;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        response.sendError(405, String.format("HTTP method [%s] not allowed", method));
    }
}

