/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Timer;

public interface MetricExporter {
    public static final Logger LOGGER = Logger.getLogger(MetricExporter.class.getName());

    public MetricExporter in(String var1, boolean var2);

    default public MetricExporter in(String scope) {
        return this.in(scope, true);
    }

    public void export(MetricID var1, Counter var2, Metadata var3);

    public void export(MetricID var1, Gauge<?> var2, Metadata var3);

    public void export(MetricID var1, Histogram var2, Metadata var3);

    public void export(MetricID var1, Timer var2, Metadata var3);

    default public void export(MetricID metricID, Metric metric, Metadata metadata) {
        if (Counter.class.isAssignableFrom(metric.getClass())) {
            this.export(metricID, (Counter)metric, metadata);
            return;
        }
        if (Gauge.class.isAssignableFrom(metric.getClass())) {
            this.export(metricID, (Gauge)metric, metadata);
            return;
        }
        if (Histogram.class.isAssignableFrom(metric.getClass())) {
            this.export(metricID, (Histogram)metric, metadata);
            return;
        }
        if (Timer.class.isAssignableFrom(metric.getClass())) {
            this.export(metricID, (Timer)metric, metadata);
            return;
        }
        LOGGER.log(Level.WARNING, "Metric type {0} for {1} is not supported", new Object[]{metric.getClass(), metricID});
    }

    public void exportComplete();
}

