/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.MetricUtils;
import fish.payara.microprofile.metrics.exception.NoSuchMetricException;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.impl.MetricRegistryImpl;
import fish.payara.microprofile.metrics.writer.MetricExporter;
import fish.payara.microprofile.metrics.writer.MetricsWriter;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HealthCheckStatsProvider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.glassfish.internal.api.Globals;

public class MetricsWriterImpl
implements MetricsWriter {
    private final MetricExporter exporter;
    private final Set<String> contextNames;
    private final Function<String, MetricsService.MetricsContext> getContextByName;
    private final Tag[] globalTags;
    private final HealthCheckService healthCheckService;

    public MetricsWriterImpl(MetricExporter exporter, Set<String> contextNames, Function<String, MetricsService.MetricsContext> getContextByName, Tag ... globalTags) {
        this.exporter = exporter;
        this.contextNames = contextNames;
        this.getContextByName = getContextByName;
        this.globalTags = globalTags;
        this.healthCheckService = (HealthCheckService)Globals.getDefaultBaseServiceLocator().getService(HealthCheckService.class, new Annotation[0]);
    }

    @Override
    public void write(String scope, String metricName) throws NoSuchRegistryException, NoSuchMetricException {
        MetricExporter exporter = this.exporter.in(scope, false);
        this.writeMetricFamily(exporter, scope, metricName);
        exporter.exportComplete();
    }

    @Override
    public void write(String scope) throws NoSuchRegistryException {
        MetricExporter exporter = this.exporter.in(scope, false);
        this.writeRegistries(exporter, scope);
        exporter.exportComplete();
    }

    @Override
    public void write() throws IOException {
        MetricExporter exporter = this.exporter;
        for (String contextName : this.contextNames) {
            MetricsService.MetricsContext context = this.getContextByName.apply(contextName);
            ConcurrentMap<String, MetricRegistry> registries = context.getRegistries();
            for (String scope : registries.keySet()) {
                exporter = exporter.in(scope);
                this.writeRegistries(exporter, scope);
            }
        }
        exporter.exportComplete();
    }

    private void writeRegistries(MetricExporter exporter, String scope) {
        for (String metricName : this.allMetricNames(scope)) {
            this.writeMetricFamily(exporter, scope, metricName);
        }
    }

    private void writeMetricFamily(MetricExporter exporter, String scope, String metricName) {
        for (String contextName : this.contextNames) {
            MetricRegistryImpl registry = this.getMetricsRegistry(contextName, scope);
            if (registry == null || registry.getMetadata(metricName) == null) continue;
            this.writeMetricFamily(exporter, contextName, metricName, registry);
        }
    }

    private void writeMetricFamily(MetricExporter exporter, String contextName, String metricName, MetricRegistryImpl registry) {
        Metadata metadata = registry.getMetadata(metricName);
        for (Map.Entry<MetricID, Metric> metric : registry.getMetrics(metricName).entrySet()) {
            Tag[] tags;
            MetricID metricID = metric.getKey();
            if (metric.getValue() instanceof HealthCheckStatsProvider && (!((HealthCheckStatsProvider)metric.getValue()).isEnabled() || !this.healthCheckService.isEnabled())) continue;
            if (this.globalTags.length > 0) {
                Tag[] tagsWithoutGlobal = metricID.getTagsAsArray();
                tags = new Tag[tagsWithoutGlobal.length + this.globalTags.length];
                System.arraycopy(this.globalTags, 0, tags, 0, this.globalTags.length);
                System.arraycopy(tagsWithoutGlobal, 0, tags, this.globalTags.length, tagsWithoutGlobal.length);
                metricID = new MetricID(metricName, tags);
            }
            if (!contextName.isEmpty()) {
                Tag[] tagsWithoutApp = metricID.getTagsAsArray();
                tags = Arrays.copyOf(tagsWithoutApp, tagsWithoutApp.length + 1);
                tags[tagsWithoutApp.length] = new Tag("mp_app", contextName);
            }
            Tag[] addingScope = MetricUtils.setScopeTagForMetric(registry.getScope(), metricID.getTagsAsArray());
            metricID = new MetricID(metricID.getName(), addingScope);
            exporter.export(metricID, metric.getValue(), metadata);
        }
    }

    private MetricRegistryImpl getMetricsRegistry(String contextName, String scope) {
        MetricsService.MetricsContext context = this.getContextByName.apply(contextName);
        return scope.equals("application") && context.isServerContext() ? null : (MetricRegistryImpl)context.getOrCreateRegistry(scope);
    }

    private Set<String> allMetricNames(String scope) {
        TreeSet<String> allNames = new TreeSet<String>();
        for (String contextName : this.contextNames) {
            MetricRegistryImpl registry = this.getMetricsRegistry(contextName, scope);
            if (registry == null) continue;
            allNames.addAll(registry.getNames());
        }
        return allNames;
    }
}

