/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.AggregateDataset;
import fish.payara.monitoring.model.DaysDataset;
import fish.payara.monitoring.model.MinutesDataset;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;

public final class HoursDataset
extends AggregateDataset<HoursDataset> {
    private static final int HOURS_PER_DAY = 24;
    private static final long MILLIS_IN_ONE_HOUR = Duration.ofHours(1L).toMillis();
    public static final HoursDataset EMPTY = new HoursDataset();
    private final DaysDataset recentDays;

    private HoursDataset() {
        this.recentDays = DaysDataset.EMPTY;
    }

    private HoursDataset(HoursDataset predecessor, MinutesDataset hour) {
        super(24, predecessor, HoursDataset.atStartOfHour(hour.lastTime()));
        this.aggregate(hour);
        this.recentDays = predecessor.recentDays.add(this);
    }

    public static long atStartOfHour(long time) {
        return Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC).withNano(0).withSecond(0).withMinute(0).toInstant().toEpochMilli();
    }

    public DaysDataset getRecentDays() {
        return this.recentDays;
    }

    public HoursDataset add(MinutesDataset hour) {
        if (!hour.endsWithLastMinuteOfHour()) {
            return this;
        }
        return new HoursDataset(this, hour);
    }

    private void aggregate(MinutesDataset hour) {
        int numberOfMinutesInAggregate = hour.size();
        int firstMinuteOfHour = hour.offset;
        int lastMiniteOfHour = Math.min(59, firstMinuteOfHour + numberOfMinutesInAggregate);
        int points = hour.getNumberOfPoints(firstMinuteOfHour);
        long min = hour.getMinimum(firstMinuteOfHour);
        long max = hour.getMaximum(firstMinuteOfHour);
        BigDecimal avg = BigDecimal.valueOf(hour.getAverage(firstMinuteOfHour));
        for (int i = firstMinuteOfHour + 1; i <= lastMiniteOfHour; ++i) {
            points += hour.getNumberOfPoints(i);
            min = Math.min(min, hour.getMinimum(i));
            max = Math.max(max, hour.getMaximum(i));
            avg = avg.add(BigDecimal.valueOf(hour.getAverage(i)));
        }
        this.setEntry(points, min, max, avg.divide(BigDecimal.valueOf(numberOfMinutesInAggregate), 1).doubleValue());
    }

    public boolean endsWithLastHourOfDay() {
        return this.isEmpty() ? false : Instant.ofEpochMilli(this.lastTime()).atOffset(ZoneOffset.UTC).getHour() == 23;
    }

    @Override
    public long getIntervalLength() {
        return MILLIS_IN_ONE_HOUR;
    }
}

