/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.ConstantDataset;
import fish.payara.monitoring.model.PartialDataset;
import fish.payara.monitoring.model.SeriesDataset;
import java.math.BigInteger;

public final class StableDataset
extends ConstantDataset {
    private final int observedValueChanges;
    private final long observedMax;
    private final long observedMin;
    private final BigInteger observedSum;
    private final int stableCount;

    public StableDataset(SeriesDataset predecessor, long time, boolean aggregate) {
        super(predecessor, time, aggregate);
        this.observedValueChanges = predecessor.getObservedValueChanges();
        this.observedMax = predecessor.getObservedMax();
        this.observedMin = predecessor.getObservedMin();
        this.observedSum = predecessor.getObservedSum().add(BigInteger.valueOf(predecessor.lastValue()));
        this.stableCount = predecessor.getStableCount() + 1;
    }

    @Override
    public int getObservedValueChanges() {
        return this.observedValueChanges;
    }

    @Override
    public long getObservedMax() {
        return this.observedMax;
    }

    @Override
    public long getObservedMin() {
        return this.observedMin;
    }

    @Override
    public BigInteger getObservedSum() {
        return this.observedSum;
    }

    @Override
    public int getStableCount() {
        return this.stableCount;
    }

    @Override
    public SeriesDataset add(long time, long value, boolean aggregate) {
        if (time == this.lastTime()) {
            return new PartialDataset(this, time, value + this.lastValue(), aggregate);
        }
        return value == this.lastValue() ? new StableDataset(this, time, aggregate) : new PartialDataset(this, time, value, aggregate);
    }

    @Override
    public int estimatedBytesMemory() {
        return 100;
    }
}

