/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.impl.callback.XWSSCallback;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;

public class DecryptionKeyCallback
extends XWSSCallback
implements Callback {
    private Request request;

    public DecryptionKeyCallback(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public static class PublicKeyBasedPrivKeyRequest
    extends PrivateKeyRequest {
        private PublicKey pk;

        public PublicKeyBasedPrivKeyRequest(PublicKey publicKey) {
            this.pk = publicKey;
        }

        public PublicKey getPublicKey() {
            return this.pk;
        }
    }

    public static class AliasSymmetricKeyRequest
    extends SymmetricKeyRequest {
        private String alias;

        public AliasSymmetricKeyRequest(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static abstract class SymmetricKeyRequest
    implements Request {
        SecretKey symmetricKey;

        protected SymmetricKeyRequest() {
        }

        public void setSymmetricKey(SecretKey symmetricKey) {
            this.symmetricKey = symmetricKey;
        }

        public SecretKey getSymmetricKey() {
            return this.symmetricKey;
        }
    }

    public static class X509CertificateBasedRequest
    extends PrivateKeyRequest {
        private X509Certificate certificate;

        public X509CertificateBasedRequest(X509Certificate certificate) {
            this.certificate = certificate;
        }

        public X509Certificate getX509Certificate() {
            return this.certificate;
        }
    }

    public static class X509IssuerSerialBasedRequest
    extends PrivateKeyRequest {
        private String issuerName;
        private BigInteger serialNumber;

        public X509IssuerSerialBasedRequest(String issuerName, BigInteger serialNumber) {
            this.issuerName = issuerName;
            this.serialNumber = serialNumber;
        }

        public String getIssuerName() {
            return this.issuerName;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class ThumbprintBasedRequest
    extends PrivateKeyRequest {
        private byte[] x509Thumbprint;

        public ThumbprintBasedRequest(byte[] x509Thumbprint) {
            this.x509Thumbprint = x509Thumbprint;
        }

        public byte[] getThumbprintIdentifier() {
            return this.x509Thumbprint;
        }
    }

    public static class X509SubjectKeyIdentifierBasedRequest
    extends PrivateKeyRequest {
        private byte[] x509SubjectKeyIdentifier;

        public X509SubjectKeyIdentifierBasedRequest(byte[] x509SubjectKeyIdentifier) {
            this.x509SubjectKeyIdentifier = x509SubjectKeyIdentifier;
        }

        public byte[] getSubjectKeyIdentifier() {
            return this.x509SubjectKeyIdentifier;
        }
    }

    public static abstract class PrivateKeyRequest
    implements Request {
        PrivateKey privateKey;

        protected PrivateKeyRequest() {
        }

        public void setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }

    public static interface Request {
    }
}

