/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelSocket;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelInputStream;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelOutputStream;
import com.sun.messaging.jmq.httptunnel.tunnel.client.HttpTunnelClientDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class HttpTunnelSocketImpl
implements HttpTunnelSocket {
    private HttpTunnelConnection conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean sockClosed = false;

    public HttpTunnelSocketImpl() {
    }

    @Override
    public void init(String serverAddr) throws IOException {
        HttpTunnelClientDriver wire = new HttpTunnelClientDriver(serverAddr);
        this.conn = wire.doConnect();
        this.initSocket();
    }

    public HttpTunnelSocketImpl(HttpTunnelConnection conn) {
        this.conn = conn;
        this.initSocket();
    }

    protected void initSocket() {
        this.is = null;
        this.os = null;
        this.sockClosed = false;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.is == null) {
            this.is = new HttpTunnelInputStream(this.conn);
        }
        return this.is;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.os == null) {
            this.os = new HttpTunnelOutputStream(this.conn);
        }
        return this.os;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        this.sockClosed = true;
        this.conn.closeConn();
    }

    @Override
    public int getConnId() {
        return this.conn.getConnId();
    }

    @Override
    public InetAddress getRemoteAddress() throws UnknownHostException, SecurityException {
        HttpTunnelConnection c = this.conn;
        if (c == null || c.getRemoteAddr() == null) {
            return null;
        }
        return InetAddress.getByName(c.getRemoteAddr());
    }

    @Override
    public int getPullPeriod() {
        return this.conn.getPullPeriod();
    }

    @Override
    public void setPullPeriod(int pullPeriod) throws IOException {
        this.conn.setPullPeriod(pullPeriod);
    }

    @Override
    public int getConnectionTimeout() {
        return this.conn.getConnectionTimeout();
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) throws IOException {
        this.conn.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public Hashtable getDebugState() {
        return this.conn.getDebugState();
    }
}

