/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedLock;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedQueueConnectionImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTransactionListener;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedXAResourceImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedXSessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceUnsupportedImpl;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JMSXAWrappedQueueSessionImpl
extends JMSXAWrappedXSessionImpl
implements JMSXAQueueSession,
JMSXAWrappedTransactionListener {
    private JMSXAWrappedQueueConnectionImpl wconn_ = null;

    public JMSXAWrappedQueueSessionImpl(QueueConnection qconn, boolean transacted, int ackMode, JMSXAWrappedQueueConnectionImpl wconn) throws JMSException {
        this.wconn_ = wconn;
        if (qconn instanceof XAQueueConnection) {
            this.session_ = ((XAQueueConnection)qconn).createXAQueueSession();
            this.xaresource_ = new JMSXAWrappedXAResourceImpl(((XASession)this.session_).getXAResource(), true, wconn.getJMSXAWrappedConnectionFactory(), wconn.getUsername(), wconn.getPassword());
            this.delaySessionCloseForRAR_ = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("delaySessionCloseForExternalJMSXAResource", this.xaresource_.getDelegatedXAResource().getClass().getName());
            this.ignoreSessionCloseForRAR_ = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("ignoreSessionCloseForExternalJMSXAResource", this.xaresource_.getDelegatedXAResource().getClass().getName());
            if (this.delaySessionCloseForRAR_) {
                JMSXAWrappedQueueSessionImpl.log("Info:", "Enable delay Session.close() for " + this.xaresource_.getDelegatedXAResource().getClass().getName());
                this.lock_ = new JMSXAWrappedLock();
                this.xaresource_.setTransactionListener(this);
            }
        } else {
            this.session_ = qconn.createQueueSession(transacted, ackMode);
            this.nonxaresource_ = new XAResourceUnsupportedImpl();
        }
    }

    @Override
    public void afterTransactionComplete(Xid foreignXid, boolean completed) {
        try {
            if (completed) {
                if (debug && this.transactions_.get(foreignXid) == null) {
                    JMSXAWrappedQueueSessionImpl.log("Warning:", "afterTransactionComplete: transaction Xid=" + foreignXid + " not found");
                }
                this.transactions_.remove(foreignXid);
            }
            if (this.transactions_.isEmpty() && this.markClosed_) {
                JMSXAWrappedQueueSessionImpl.dlog("All transaction completed, hard close session " + this.session_ + " " + this.session_.getClass().getName());
                this.closed_ = true;
            }
        }
        finally {
            this.lock_.releaseLock();
        }
        if (this.closed_) {
            try {
                this.hardClose();
            }
            catch (JMSException e) {
                JMSXAWrappedQueueSessionImpl.log("Warning:", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() throws JMSException {
        if (this.delaySessionCloseForRAR_) {
            if (this.session_.getMessageListener() != null) {
                JMSXAWrappedQueueSessionImpl.log("Info:", "Session MessageListener set. No delay session close for session " + this.session_ + " " + this.session_.getClass().getName());
            } else {
                this.lock_.acquireLock();
                try {
                    if (this.transactions_.isEmpty() || this.xaresource_ == null) {
                        this.closed_ = true;
                    } else {
                        this.markClosed_ = true;
                    }
                }
                finally {
                    this.lock_.releaseLock();
                }
                if (this.closed_) {
                    this.hardClose();
                }
                return;
            }
        }
        if (this.ignoreSessionCloseForRAR_) {
            this.hardClose(false);
            return;
        }
        this.hardClose();
    }

    @Override
    public XAResource getXAResource() {
        if (this.session_ instanceof XASession) {
            return this.xaresource_;
        }
        return this.nonxaresource_;
    }

    @Override
    public QueueSession getQueueSession() throws JMSException {
        if (this.closed_) {
            throw new IllegalStateException("JMSXWrapped Session has been closed");
        }
        if (this.markClosed_) {
            throw new IllegalStateException("JMSXAWrapped Session is closed");
        }
        if (this.session_ instanceof XASession) {
            return ((XAQueueSession)this.session_).getQueueSession();
        }
        return (QueueSession)this.session_;
    }

    @Override
    void removeSelfFromConnection() {
        this.wconn_.removeSession(this);
    }
}

