/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.TransactionPrepareStateFAILEDException;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.util.DebugConverters;
import com.sun.messaging.jmq.util.JMQXid;
import jakarta.jms.JMSException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource,
XAResourceForJMQ {
    private SessionImpl _session;
    private ConnectionImpl _connection;
    private Transaction _transaction = null;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private static final Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static final Integer XA_ROLLBACK_ONLY = 4;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;
    public static final boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static final boolean XATracking = !turnOffXATracking;
    private static Map<XAResourceImpl, JMQXid> lastInternalRBCache = Collections.synchronizedMap(new LinkedHashMap());
    private boolean lastInternalRB = false;
    private ConnectionConsumerImpl connectionConsumer = null;
    JMQXid currentJMQXid = null;
    private static final String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceImpl";
    private static final Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceImpl");
    private static final String _lgrPrefix = "XAResourceImpl: ";

    public XAResourceImpl(SessionImpl session) throws JMSException {
        this._session = session;
        this._connection = session.connection;
        this.resourceManagerId = this._connection.protocolHandler.generateUID();
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:new:RMId=" + this.resourceManagerId);
        }
    }

    protected void setConnectionConsumer(ConnectionConsumerImpl cc) {
        this.connectionConsumer = cc;
    }

    protected ConnectionConsumerImpl getConnectionConsumer() {
        return this.connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid foreignXid, boolean onePhase) throws XAException {
        XAException xae;
        boolean insyncstate = false;
        boolean checkrollback = false;
        boolean rbrollback = false;
        Exception rbrollbackex = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Commit  " + this.printXid(foreignXid) + " (onePhase=" + onePhase + ")");
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:onePhase=" + onePhase + "\txid=\n" + jmqXid.toString());
        }
        if (this._session.isRollbackOnly) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            XAException xae2 = new XAException(-7);
            xae2.initCause(this._session.rollbackCause);
            throw xae2;
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                if (Debug.debug) {
                    Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using 0 as txnID");
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HACommit(foreignXid, jmqXid, onePhase, insyncstate);
                } else {
                    try {
                        this._connection.getProtocolHandler().commit(0L, onePhase ? 0x40000000 : 0, jmqXid);
                    }
                    catch (JMSException e) {
                        if (onePhase) {
                            checkrollback = true;
                        }
                        throw e;
                    }
                }
            } else {
                if (Debug.debug) {
                    Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using real txnID");
                }
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    insyncstate = true;
                    this._session.receiveCommit();
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HACommit(foreignXid, jmqXid, onePhase, insyncstate);
                    this._session.clearUnackedMessageQ();
                } else {
                    try {
                        this._transaction.commitXATransaction(jmqXid, onePhase);
                    }
                    catch (JMSException e) {
                        if (onePhase) {
                            checkrollback = true;
                        }
                        throw e;
                    }
                }
            }
            this._connection.closeConnectionFromRA();
            return;
        }
        catch (Exception jmse) {
            Exception e1;
            Debug.printStackTrace(jmse);
            if (jmse instanceof XAException) {
                throw (XAException)jmse;
            }
            if (jmse instanceof RemoteAcknowledgeException && checkrollback) {
                rbrollbackex = jmse;
                rbrollback = true;
            }
            if (!rbrollback && checkrollback && jmse instanceof JMSException && ((JMSException)((Object)jmse)).getErrorCode().equals("C4036") && (e1 = ((JMSException)((Object)jmse)).getLinkedException()) instanceof JMSException && !((JMSException)((Object)e1)).getErrorCode().equals(Status.getString(404))) {
                SessionImpl.sessionLogger.log(Level.WARNING, "Exception on 1-phase commit transaction " + jmqXid + ", will rollback", jmse);
                rbrollbackex = jmse;
                rbrollback = true;
            }
            if (!rbrollback) {
                XAException xae3 = new XAException(-7);
                xae3.initCause(jmse);
                throw xae3;
            }
        }
        finally {
            if (!rbrollback) {
                boolean throwExceptionIfNotFound = false;
                XAResourceImpl[] resources = XAResourceMap.getXAResources(jmqXid, throwExceptionIfNotFound);
                for (int i = 0; i < resources.length; ++i) {
                    XAResourceImpl xari = resources[i];
                    xari.clearTransactionInfo();
                    xari.finishCommit();
                }
                XAResourceMap.unregister(jmqXid);
            }
            if (insyncstate) {
                this._session.releaseInSyncState();
            }
        }
        try {
            this.rollback(foreignXid);
            lastInternalRBCache.put(this, jmqXid);
            this.lastInternalRB = true;
            xae = new XAException(100);
            xae.initCause(rbrollbackex);
        }
        catch (Throwable t) {
            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jmqXid + " after 1-phase-commit failure", t);
            xae = new XAException(-7);
            xae.initCause(rbrollbackex);
        }
        throw xae;
    }

    protected void close() {
        if (this.currentJMQXid != null) {
            SessionImpl.sessionLogger.log(Level.INFO, "Closing XA session with a transaction pending");
            XAResourceMap.unregisterResource(this, this.currentJMQXid);
            this.clearTransactionInfo();
            this.currentJMQXid = null;
        }
        this.connectionConsumer = null;
    }

    protected void finishCommit() {
        this._session.switchOffXATransaction();
        this.currentJMQXid = null;
        this.connectionConsumer = null;
    }

    protected void finishRollback() {
        this._session.failoverOccurred = false;
        this._session.switchOffXATransaction();
        this._session.isRollbackOnly = false;
        this._session.rollbackCause = null;
        this.currentJMQXid = null;
        this.connectionConsumer = null;
    }

    @Override
    public void end(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: XAResourceImpl (" + this.hashCode() + ") End     " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (this._connection._isClosed()) {
            XAException xae = new XAException(-7);
            throw xae;
        }
        this.resourceState = this.isFail(flags) ? 2 : (this.isSuspend(flags) ? 3 : 4);
        if (this.resourceState == 4) {
            boolean allComplete = true;
            XAResourceImpl[] resources = XAResourceMap.getXAResources(jmqXid, false);
            for (int i = 0; i < resources.length; ++i) {
                XAResourceImpl xari = resources[i];
                if (xari.isComplete()) continue;
                allComplete = false;
            }
            if (allComplete) {
                this.sendEndToBroker(flags, false, jmqXid);
            } else {
                this.sendEndToBroker(flags, true, jmqXid);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(flags, false, jmqXid);
        } else if (this.resourceState == 3) {
            // empty if block
        }
    }

    private void sendEndToBroker(int flags, boolean jmqnoop, JMQXid jmqXid) throws XAException {
        try {
            this._connection.getProtocolHandler().endTransaction(0L, jmqnoop, flags, jmqXid);
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        XAResourceMap.unregister(jmqXid);
        if (this.currentJMQXid != null && this.currentJMQXid.equals(jmqXid)) {
            this.currentJMQXid = null;
            this.connectionConsumer = null;
            this.clearTransactionInfo();
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        if (foreignXaRes instanceof XAResourceImpl) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)foreignXaRes));
        }
        return false;
    }

    @Override
    public boolean isSameJMQRM(XAResourceForJMQ xaResource) {
        boolean result = this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xaResource.getBrokerSessionID();
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            long myBrokerSessionID = this.getBrokerSessionID();
            long otherBrokerSessionID = xaResource.getBrokerSessionID();
            SessionImpl.sessionLogger.log(Level.FINE, "myBrokerSessionID=" + myBrokerSessionID + " otherBrokerSessionID=" + otherBrokerSessionID + " isSameRM()=" + result);
        }
        return result;
    }

    @Override
    public long getBrokerSessionID() {
        return this._connection.getBrokerSessionID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepare(Xid foreignXid, boolean onePhase, boolean insyncstate) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: XAResourceImpl (" + this.hashCode() + ") Prepare     " + this.printXid(foreignXid));
        }
        int result = 0;
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:txid=\n" + jmqXid.toString());
        }
        try {
            if (this._session.isRollbackOnly) {
                Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
                if (this.connectionConsumer != null && this._session.rollbackCause instanceof RemoteAcknowledgeException) {
                    throw this._session.rollbackCause;
                }
                XAException xae = new XAException(-7);
                xae.initCause(this._session.rollbackCause);
                throw xae;
            }
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (onePhase) {
                    this._connection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
                } else {
                    this._transaction.prepareXATransaction(jmqXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Throwable jmse) {
            Debug.printStackTrace(jmse);
            if (jmse instanceof XAException) {
                throw (XAException)jmse;
            }
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            if (jmse instanceof RemoteAcknowledgeException) {
                if (this.connectionConsumer != null) {
                    ConnectionConsumerImpl cc = this.connectionConsumer;
                    if (!cc.canRecreate()) {
                        throw xae;
                    }
                    try {
                        this.rollback(foreignXid);
                        xae = new XAException(100);
                        xae.initCause(jmse);
                        lastInternalRBCache.put(this, jmqXid);
                        this.lastInternalRB = true;
                    }
                    catch (Throwable t) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jmqXid + " after prepared failed with remote exception", t);
                    }
                    finally {
                        cc.notifyRecreation((RemoteAcknowledgeException)((Object)jmse));
                    }
                } else if (this._session.isRemoteException((RemoteAcknowledgeException)((Object)jmse))) {
                    try {
                        this.rollback(foreignXid);
                        xae = new XAException(100);
                        xae.initCause(jmse);
                        lastInternalRBCache.put(this, jmqXid);
                        this.lastInternalRB = true;
                    }
                    catch (Throwable t) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jmqXid + " after prepare failed with remote exception", t);
                    }
                    if (!insyncstate) {
                        try {
                            this._session.setInSyncState();
                        }
                        catch (Throwable t) {
                            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on setting sync state after prepare " + jmqXid + " failed with remote exception", t);
                            throw xae;
                        }
                    }
                    try {
                        this._session.recreateConsumers(true);
                    }
                    catch (Throwable t) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on recreating consumers after prepare " + jmqXid + " failed with remote exception", t);
                        throw xae;
                    }
                    finally {
                        if (!insyncstate) {
                            this._session.releaseInSyncState();
                        }
                    }
                }
            } else if (jmse instanceof TransactionPrepareStateFAILEDException) {
                if (onePhase) {
                    if (this._transaction == null || this._session.isClosed || this.connectionConsumer != null) {
                        try {
                            this._connection.getProtocolHandler().rollback(0L, jmqXid, this.connectionConsumer != null);
                            xae = new XAException(100);
                            xae.initCause(jmse);
                            lastInternalRBCache.put(this, jmqXid);
                            this.lastInternalRB = true;
                        }
                        catch (Throwable t) {
                            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback after TransactionPrepareStateFAILEDException " + jmqXid, t);
                            throw xae;
                        }
                    }
                    if (!insyncstate) {
                        try {
                            this._session.setInSyncState();
                        }
                        catch (Throwable t) {
                            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on setting sync state on TransactionPrepareStateFAILEDException " + jmqXid, t);
                            throw xae;
                        }
                    }
                    try {
                        this._session.rollbackAfterReceiveCommit(jmqXid);
                        xae = new XAException(100);
                        xae.initCause(jmse);
                        lastInternalRBCache.put(this, jmqXid);
                        this.lastInternalRB = true;
                    }
                    catch (Throwable t) {
                        SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback after TransactionPrepareStateFAILEDException " + jmqXid, t);
                        throw xae;
                    }
                    finally {
                        if (!insyncstate) {
                            this._session.releaseInSyncState();
                        }
                    }
                }
                xae = new XAException(-3);
                xae.initCause(jmse);
            }
            throw xae;
        }
        this.resourceState = 5;
        return result;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        Xid[] result = null;
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:recover:flags=" + flags);
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception oce) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            result = this._connection.getProtocolHandler().recover(flags);
            this._connection.closeConnectionFromRA();
        }
        catch (Exception jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public void rollback(Xid foreignXid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Rollback  " + this.printXid(foreignXid) + ")");
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:rollback:txid=\n" + jmqXid.toString());
        }
        try {
            block22: {
                try {
                    this._connection.openConnectionFromRA(true);
                }
                catch (Exception oce) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._connection.openConnectionFromRA(true);
                }
                if (this._transaction == null) {
                    try {
                        if (this._connection.isConnectedToHABroker) {
                            this.HARollback(jmqXid, false);
                            break block22;
                        }
                        this._connection.getProtocolHandler().rollback(0L, jmqXid);
                    }
                    catch (JMSException e) {
                        this.checkInternalRB(e, jmqXid);
                    }
                } else {
                    this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                    if (!this._session.isClosed) {
                        this._session.setInSyncState();
                        this._session.receiveRollback();
                    }
                    try {
                        if (this._connection.isConnectedToHABroker) {
                            this.HARollback(jmqXid, false);
                        } else {
                            this._transaction.rollbackXATransaction(jmqXid);
                        }
                    }
                    catch (JMSException e) {
                        this.checkInternalRB(e, jmqXid);
                    }
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        finally {
            boolean throwExceptionIfNotFound = false;
            XAResourceImpl[] resources = XAResourceMap.getXAResources(jmqXid, throwExceptionIfNotFound);
            for (int i = 0; i < resources.length; ++i) {
                XAResourceImpl xari = resources[i];
                xari.finishRollback();
                xari.clearTransactionInfo();
            }
            XAResourceMap.unregister(jmqXid);
            this._session.releaseInSyncState();
        }
    }

    private void checkInternalRB(JMSException e, JMQXid jmqXid) throws JMSException {
        Exception e1;
        if (e.getErrorCode().equals("C4036") && (e1 = e.getLinkedException()) instanceof JMSException && ((JMSException)((Object)e1)).getErrorCode().equals(Status.getString(404)) && lastInternalRBCache.containsValue(jmqXid)) {
            ConnectionImpl.connectionLogger.log(Level.INFO, "Transaction " + jmqXid + " has already been rolled back");
            lastInternalRBCache.remove(this);
            this.lastInternalRB = false;
            return;
        }
        throw e;
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return false;
    }

    @Override
    public void start(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("XAResourceImpl: (" + this.hashCode() + ") Start   " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (this.lastInternalRB) {
            lastInternalRBCache.remove(this);
            this.lastInternalRB = false;
        }
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:start:flags=" + flags + "\txid=\n" + jmqXid.toString());
        }
        try {
            this._session.switchOnXATransaction();
            this._transaction = this._session.transaction;
            this._transaction.startXATransaction(flags, jmqXid);
            if (!this.isResume(flags)) {
                XAResourceMap.register(jmqXid, this, this.isJoin(flags));
            }
            this.currentJMQXid = jmqXid;
        }
        catch (JMSException jmse) {
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.resourceState = 1;
    }

    protected static synchronized void setState(Object key, Object value) {
        xaTable.put(key, value);
    }

    protected static synchronized Integer getState(Object key) {
        return (Integer)xaTable.get(key);
    }

    protected static synchronized Object removeXid(Object key) {
        return xaTable.remove(key);
    }

    protected static synchronized boolean isPrepared(Object key) {
        boolean st = false;
        Integer value = (Integer)xaTable.get(key);
        if (value != null && value.intValue() == XA_PREPARE.intValue()) {
            st = true;
        }
        return st;
    }

    protected static synchronized boolean isRollbackOnly(Object key) {
        boolean st = false;
        Integer value = (Integer)xaTable.get(key);
        if (value != null && value.intValue() == XA_ROLLBACK_ONLY.intValue()) {
            st = true;
        }
        return st;
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        int result = 0;
        JMQXid jmqXid = null;
        if (this._connection.isConnectedToHABroker) {
            jmqXid = new JMQXid(foreignXid);
        }
        try {
            this.prepare(foreignXid, false, false);
        }
        catch (XAException xae) {
            if (this._connection.isConnectedToHABroker) {
                this.checkPrepareStatus(xae, jmqXid);
            }
            throw xae;
        }
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XA_PREPARE);
        }
        return result;
    }

    private boolean isXATracking() {
        return this._connection.isConnectedToHABroker() && XATracking;
    }

    private void checkPrepareStatus(XAException xae, JMQXid jmqXid) throws XAException {
        if (!this._connection.imqReconnect) {
            throw xae;
        }
        try {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw xae;
            }
            this.verifyPrepare(jmqXid);
        }
        catch (XAException xae2) {
            throw xae2;
        }
        catch (Exception e) {
            XAException xae3 = new XAException(-7);
            xae3.initCause(e);
            throw xae3;
        }
    }

    private void verifyPrepare(JMQXid jmqXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jmqXid);
        int state = this._connection.protocolHandler.verifyHATransaction(0L, 1, jmqXid);
        switch (state) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + jmqXid);
                return;
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid, boolean insyncstate) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true, insyncstate);
            tstate = 2;
            if (this.isXATracking()) {
                xaTable.put(jmqXid, XAResourceForRA.XA_PREPARE);
            }
            this._connection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            if (jmse instanceof XAException && ((XAException)jmse).errorCode == 100) {
                throw (XAException)jmse;
            }
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        XAResourceImpl.removeXid(jmqXid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HATwoPhaseCommit(JMQXid jmqXid) throws JMSException, XAException {
        block2: {
            try {
                this._connection.getProtocolHandler().commit(0L, 0, jmqXid);
            }
            catch (JMSException jmse) {
                if (!this.isXATracking()) throw jmse;
                Integer ts = (Integer)xaTable.get(jmqXid);
                if (ts == null || ts != 2) break block2;
                this.checkCommitStatus((Exception)((Object)jmse), 2, jmqXid, false);
            }
        }
        XAResourceImpl.removeXid(jmqXid);
    }

    private void checkCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(cause, tstate, jmqXid, onePhase);
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                throw (JMSException)((Object)ex);
            }
            if (ex instanceof XAException) {
                throw (XAException)ex;
            }
            XAException xae = new XAException(-7);
            xae.initCause(ex);
            throw xae;
        }
    }

    private void doCheckCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws Exception {
        if (!this._connection.imqReconnect) {
            throw cause;
        }
        SessionImpl.yield();
        this._connection.checkReconnecting(null);
        if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
            throw cause;
        }
        this.verifyTransaction(tstate, jmqXid, onePhase);
    }

    private void verifyTransaction(int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        int state = this._connection.protocolHandler.verifyHATransaction(0L, tstate, jmqXid);
        switch (state) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + jmqXid);
                    this._connection.getProtocolHandler().commit(0L, 0, jmqXid, onePhase);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + jmqXid);
                    return;
                }
                catch (JMSException jmse) {
                    SessionImpl.yield();
                    this._connection.checkReconnecting(null);
                    throw jmse;
                }
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void HACommit(Xid foreignXid, JMQXid jmqXid, boolean onePhase, boolean insyncstate) throws JMSException, XAException {
        if (onePhase) {
            this.HAOnePhaseCommit(foreignXid, jmqXid, insyncstate);
        } else {
            this.HATwoPhaseCommit(jmqXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HARollback(JMQXid jmqXid, boolean redeliverMsgs) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jmqXid, redeliverMsgs);
        }
        catch (JMSException jmse) {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw jmse;
            }
            this.retryRollBack(jmqXid, redeliverMsgs);
        }
        finally {
            XAResourceImpl.removeXid(jmqXid);
        }
    }

    private void retryRollBack(JMQXid jmqXid, boolean redeliverMsgs) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jmqXid, redeliverMsgs, true);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer tstate = (Integer)xaTable.get(jmqXid);
                if (tstate != null && tstate != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jmse.toString());
                }
                throw jmse;
            }
            throw jmse;
        }
    }

    private boolean isJoin(int flags) {
        return (flags & 0x200000) == 0x200000;
    }

    private boolean isResume(int flags) {
        return (flags & 0x8000000) == 0x8000000;
    }

    @Override
    public boolean isComplete() {
        return this.resourceState == 4;
    }

    @Override
    public void clearTransactionInfo() {
        this.resourceState = 0;
    }

    private String printXid(Xid foreignXid) {
        return DebugConverters.toString(foreignXid);
    }

    private boolean isNoFlags(int flags) {
        return (flags & 0) == 0;
    }

    private boolean isFail(int flags) {
        return (flags & 0x20000000) == 0x20000000;
    }

    private boolean isOnePhase(int flags) {
        return (flags & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int flags) {
        return (flags & 0x4000000) == 0x4000000;
    }

    private boolean isSuspend(int flags) {
        return (flags & 0x2000000) == 0x2000000;
    }

    private boolean isTMENDRSCAN(int flags) {
        return (flags & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int flags) {
        return (flags & 0x1000000) == 0x1000000;
    }

    private String printFlags(int flags) {
        Object result = "(Flags: ";
        if (this.isJoin(flags)) {
            result = (String)result + "JOIN ";
        }
        if (this.isNoFlags(flags)) {
            result = (String)result + "TMNOFLAGS ";
        }
        if (this.isFail(flags)) {
            result = (String)result + "TMFAIL ";
        }
        if (this.isOnePhase(flags)) {
            result = (String)result + "TMONEPHASE ";
        }
        if (this.isResume(flags)) {
            result = (String)result + "TMRESUME ";
        }
        if (this.isSuccess(flags)) {
            result = (String)result + "TMSUCCESS ";
        }
        if (this.isSuspend(flags)) {
            result = (String)result + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(flags)) {
            result = (String)result + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(flags)) {
            result = (String)result + "TMSTARTRSCAN ";
        }
        result = (String)result + ")";
        return result;
    }
}

