/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap<K, V>
implements Map<K, V> {
    String name = "Unknown";
    HashMap<K, Reference<V>> baseMap = new HashMap();
    private ReferenceQueue<K> myqueue = new ReferenceQueue();
    private Collection<V> values = null;
    private Set<Map.Entry<K, V>> entrySet = null;

    public WeakValueHashMap(String name) {
        this.name = name;
    }

    public String toString() {
        return "WeakValueHashMap(" + this.name + ")";
    }

    private void cleanupMap() {
        Reference<K> r;
        while ((r = this.myqueue.poll()) != null) {
            MyWeakValueReference wr = (MyWeakValueReference)r;
            this.baseMap.remove(wr.getOriginalKey());
        }
    }

    @Override
    public int size() {
        this.cleanupMap();
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanupMap();
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        WeakReference k = (WeakReference)this.baseMap.get(key);
        return k != null && !k.isEnqueued();
    }

    @Override
    public boolean containsValue(Object value) {
        this.cleanupMap();
        return this.baseMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.cleanupMap();
        Reference<V> ref = this.baseMap.get(key);
        return ref == null ? null : (ref.isEnqueued() ? null : ref.get());
    }

    @Override
    public V put(K key, V value) {
        this.cleanupMap();
        MyWeakValueReference<K, V> ref = new MyWeakValueReference<K, V>(key, value, this.myqueue);
        WeakReference oldref = this.baseMap.put(key, ref);
        return oldref == null ? null : (oldref.isEnqueued() ? null : oldref.get());
    }

    @Override
    public V remove(Object key) {
        this.cleanupMap();
        WeakReference ref = (WeakReference)this.baseMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.cleanupMap();
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.cleanupMap();
        this.baseMap.clear();
    }

    @Override
    public Set<K> keySet() {
        this.cleanupMap();
        return this.baseMap.keySet();
    }

    @Override
    public Collection<V> values() {
        this.cleanupMap();
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.cleanupMap();
        EntrySet vs = this.entrySet;
        return vs != null ? vs : (this.entrySet = new EntrySet());
    }

    @Override
    public boolean equals(Object o) {
        this.cleanupMap();
        if (o instanceof WeakValueHashMap) {
            return this.baseMap.equals(((WeakValueHashMap)o).baseMap);
        }
        return this.baseMap.equals(o);
    }

    @Override
    public int hashCode() {
        this.cleanupMap();
        return this.baseMap.hashCode();
    }

    public static void main(String[] args) {
        int i;
        WeakValueHashMap<Object, String> hm = new WeakValueHashMap<Object, String>("test");
        Object key1 = new Object();
        Object key2 = new Object();
        String value1 = "value1";
        String value2 = "value2";
        hm.put(key1, value1);
        hm.put(key2, value2);
        for (i = 0; i < 10; ++i) {
            System.gc();
        }
        System.out.println("K1 get " + (String)hm.get(key1));
        System.out.println("K2 get " + (String)hm.get(key2));
        value2 = null;
        value1 = null;
        for (i = 0; i < 100; ++i) {
            System.gc();
        }
        System.out.println("K1 get " + (String)hm.get(key1));
        System.out.println("K2 get " + (String)hm.get(key2));
    }

    class WeakValueEntry
    implements Map.Entry<K, V> {
        K key = null;
        V value = null;

        WeakValueEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new newEntryIterator(WeakValueHashMap.this.baseMap.entrySet().iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueHashMap.this.containsKey(e.getKey());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakValueHashMap.this.clear();
        }
    }

    private class newEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        Map.Entry<K, V> nextentry = null;
        Iterator<Map.Entry<K, Reference<V>>> itr = null;

        newEntryIterator(Iterator<Map.Entry<K, Reference<V>>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            if (this.nextentry != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            Map.Entry mentry = this.itr.next();
            WeakReference nextref = (WeakReference)mentry.getValue();
            while (nextref.isEnqueued()) {
                this.itr.remove();
                mentry = this.itr.next();
                nextref = (WeakReference)mentry.getValue();
            }
            this.nextentry = new WeakValueEntry(mentry.getKey(), nextref.get());
            return this.nextentry != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextentry == null && !this.hasNext()) {
                return null;
            }
            Map.Entry returnval = this.nextentry;
            this.nextentry = null;
            return returnval;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(WeakValueHashMap.this.baseMap.values().iterator());
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakValueHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakValueHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        WeakReference<V> next = null;
        Iterator<Reference<V>> itr = null;

        ValueIterator(Iterator<Reference<V>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.itr.hasNext()) {
                return false;
            }
            this.next = (WeakReference)this.itr.next();
            while (this.next.isEnqueued()) {
                this.itr.remove();
                if (this.itr.hasNext()) {
                    this.next = (WeakReference)this.itr.next();
                    continue;
                }
                this.next = null;
                break;
            }
            return this.next != null;
        }

        @Override
        public V next() {
            if (this.next == null && !this.hasNext()) {
                return null;
            }
            while (this.next.isEnqueued()) {
                this.itr.remove();
                this.next = null;
                if (this.hasNext()) continue;
            }
            Object refval = this.next == null ? null : (Object)this.next.get();
            this.next = null;
            return refval;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static class MyWeakValueReference<K, T>
    extends WeakReference<T> {
        K mykey = null;

        MyWeakValueReference(K key, T value, ReferenceQueue<? super T> q) {
            super(value, q);
            this.mykey = key;
        }

        public int hashCode() {
            return this.mykey.hashCode();
        }

        public K getOriginalKey() {
            return this.mykey;
        }

        public String toString() {
            return this.mykey.toString();
        }
    }
}

