/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DirectStreamPacket
extends DirectPacket
implements StreamMessage {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private boolean writePerformed = false;
    private boolean byteArrayReadState = false;
    private ByteArrayInputStream byteArrayFieldInputStream = null;
    private Object notYetProcessedPrimitiveObject = null;
    private static final String _className = "com.sun.messaging.jms.ra.DirectStreamPacket";

    public DirectStreamPacket(DirectSession ds) throws JMSException {
        super(ds);
        if (_logFINE) {
            Object[] params = new Object[2];
            params[0] = ds;
            _loggerOC.entering(_className, "constructor()", params);
        }
        this._initializeOutputStreams();
    }

    public DirectStreamPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds) throws JMSException {
        super(jmsPacket, consumerId, ds);
        this._getMessageBodyFromPacket();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
        this._initializeOutputStreams();
    }

    public boolean readBoolean() throws JMSException {
        Object obj = this._readPrimitiveObject("readBoolean()");
        return ConvertValue.toBoolean(obj);
    }

    public byte readByte() throws JMSException {
        Object obj = this._readPrimitiveObject("readByte()");
        try {
            byte b = ConvertValue.toByte(obj);
            return b;
        }
        catch (NumberFormatException nfe) {
            this.notYetProcessedPrimitiveObject = obj;
            throw nfe;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        int bytesRead = -1;
        if (this.messageBody == null) {
            this.checkForWriteOnlyMessageBody("readBytes(byte[])");
            return -1;
        }
        if (!this.byteArrayReadState) {
            Object obj = this._readPrimitiveObject("readBytes(byte[])");
            if (obj == null) {
                return -1;
            }
            if (!(obj instanceof byte[])) {
                String errorString = "Exception:StreamMessage:readBytes():Object read is not byte[]:Actual type=" + obj.getClass().getName();
                throw new MessageFormatException(errorString);
            }
            byte[] data = (byte[])obj;
            if (data.length == 0) {
                return 0;
            }
            this.byteArrayFieldInputStream = new ByteArrayInputStream(data);
            this.byteArrayReadState = true;
        }
        if ((bytesRead = this.byteArrayFieldInputStream.read(value, 0, value.length)) < value.length) {
            this.byteArrayReadState = false;
            try {
                this.byteArrayFieldInputStream.close();
                this.byteArrayFieldInputStream = null;
            }
            catch (IOException e) {
                JMSException jmse = new JMSException("Exception:StreamMessage:readBytes()" + e.getMessage());
                jmse.initCause((Throwable)e);
                throw jmse;
            }
        }
        return bytesRead;
    }

    public char readChar() throws JMSException {
        Object obj = this._readPrimitiveObject("readChar()");
        return ConvertValue.toChar(obj);
    }

    public double readDouble() throws JMSException {
        Object obj = this._readPrimitiveObject("readDouble()");
        return ConvertValue.toDouble(obj);
    }

    public float readFloat() throws JMSException {
        Object obj = this._readPrimitiveObject("readFloat()");
        return ConvertValue.toFloat(obj);
    }

    public int readInt() throws JMSException {
        Object obj = this._readPrimitiveObject("readInt()");
        return ConvertValue.toInt(obj);
    }

    public long readLong() throws JMSException {
        Object obj = this._readPrimitiveObject("readLong()");
        return ConvertValue.toLong(obj);
    }

    public Object readObject() throws JMSException {
        Object obj = this._readPrimitiveObject("readObject()");
        return obj;
    }

    public short readShort() throws JMSException {
        Object obj = this._readPrimitiveObject("readShort()");
        return ConvertValue.toShort(obj);
    }

    public String readString() throws JMSException {
        Object obj = this._readPrimitiveObject("readString()");
        return ConvertValue.toString(obj);
    }

    public void reset() throws JMSException {
        String methodName = "reset()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this._reset(methodName);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this._writePrimitiveObject(value, "writeBoolean()");
    }

    public void writeByte(byte value) throws JMSException {
        this._writePrimitiveObject(value, "writeByte()");
    }

    public void writeBytes(byte[] value) throws JMSException {
        this._writePrimitiveObject(value, "writeBytes(byte[])");
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        byte[] out = new byte[length];
        System.arraycopy(value, offset, out, 0, length);
        this._writePrimitiveObject(out, "writeBytes(byte[], offset, length)");
    }

    public void writeChar(char value) throws JMSException {
        this._writePrimitiveObject(Character.valueOf(value), "writeChar()");
    }

    public void writeDouble(double value) throws JMSException {
        this._writePrimitiveObject(value, "writeDouble()");
    }

    public void writeFloat(float value) throws JMSException {
        this._writePrimitiveObject(Float.valueOf(value), "writeFloat()");
    }

    public void writeInt(int value) throws JMSException {
        this._writePrimitiveObject(value, "writeInt()");
    }

    public void writeLong(long value) throws JMSException {
        this._writePrimitiveObject(value, "writeLong()");
    }

    public void writeObject(Object value) throws JMSException {
        this._checkValidObjectType(value, "writeObject()");
        this._writePrimitiveObject(value, "writeObject()");
    }

    public void writeShort(short value) throws JMSException {
        this._writePrimitiveObject(value, "writeShort()");
    }

    public void writeString(String value) throws JMSException {
        this._writePrimitiveObject(value, "writeString()");
    }

    @Override
    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(4);
    }

    @Override
    protected void _setBodyToPacket() throws JMSException {
        this._reset("_setBodyToPacket");
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody, 0, this.messageBody.length);
            }
            catch (Exception ex) {
                String errMsg = "MQJMSRA_DM4001: :ERROR setting StreamMessage body:Exception=" + ex.getMessage();
                _loggerJM.severe(errMsg);
                JMSException jmse = new JMSException(errMsg);
                jmse.initCause((Throwable)ex);
                throw jmse;
            }
        }
    }

    @Override
    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
        this._reset("_getMessageBodyFromPacket");
    }

    private void _reset(String methodName) throws JMSException {
        super._setReadOnlyBody(true);
        try {
            if (this.writePerformed) {
                this.objectOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.toByteArray();
                this.objectOutputStream.close();
                this.byteArrayOutputStream.close();
                this.writePerformed = false;
            }
            if (this.messageBody != null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new FilteringObjectInputStream(this.byteArrayInputStream);
            }
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:StreamMessage." + methodName + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.byteArrayReadState = false;
        this.notYetProcessedPrimitiveObject = null;
    }

    private Object _readPrimitiveObject(String methodName) throws JMSException {
        Object obj = null;
        this.checkForWriteOnlyMessageBody(methodName);
        this._checkReadBytesState(methodName);
        try {
            if (this.notYetProcessedPrimitiveObject != null) {
                obj = this.notYetProcessedPrimitiveObject;
                this.notYetProcessedPrimitiveObject = null;
            } else {
                obj = this.objectInputStream.readObject();
            }
        }
        catch (EOFException eofe) {
            MessageEOFException meofe = new MessageEOFException("Unexpected EOFException: " + eofe.getMessage());
            throw meofe;
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Exception on readObject:" + e.getMessage());
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        return obj;
    }

    private void _writePrimitiveObject(Object obj, String methodName) throws JMSException {
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.objectOutputStream.writeObject(obj);
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :Exception:StreamMessage." + methodName + ":message=" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.writePerformed = true;
    }

    private void _checkReadBytesState(String methodName) throws MessageFormatException {
        if (this.byteArrayReadState) {
            throw new MessageFormatException("MessageFormatException on" + methodName);
        }
    }

    private void _initializeOutputStreams() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Exception:StreamMessage:initializing output streams:" + e.getMessage());
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    private void _checkValidObjectType(Object value, String name) throws MessageFormatException {
        if (value == null) {
            return;
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
            String errMsg = "MQJMSRA_DM4001: :StreamMessage:setObject():Invalid type:name=" + name + ":type=" + value.getClass().getName();
            _loggerJM.severe(errMsg);
            MessageFormatException mfe = new MessageFormatException(errMsg);
            throw mfe;
        }
    }
}

