/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.admin.remote.ServerRemoteRestAdminCommand;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.admin.cli.ConnectionPoolUtil;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="flush-connection-pool")
@PerLookup
@I18n(value="flush.connection.pool")
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="flush-connection-pool", description="flush-connection-pool")})
public class FlushInstancesConnectionPool
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger("org.glassfish.connectors.admin.cli");
    @Param(name="pool_name", primary=true)
    private String poolName;
    @Param(name="appname", optional=true)
    private String applicationName;
    @Param(name="modulename", optional=true)
    private String moduleName;
    @Inject
    private Applications applications;
    @Inject
    private ConnectionPoolUtil poolUtil;
    @Inject
    CommandRunner commandRunner;
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator habitat;
    @Inject
    PayaraExecutorService executor;

    public void execute(final AdminCommandContext context) {
        Application application;
        final ActionReport report = context.getActionReport();
        Resources resources = this.domain.getResources();
        String scope = "";
        if (this.moduleName != null) {
            if (!this.poolUtil.isValidModule(this.applicationName, this.moduleName, this.poolName, report)) {
                report.setMessage("Modulename is not that of a valid module: " + this.moduleName);
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            Module module = application.getModule(this.moduleName);
            resources = module.getResources();
            scope = "java:module/";
        } else if (this.applicationName != null) {
            if (!this.poolUtil.isValidApplication(this.applicationName, this.poolName, report)) {
                report.setMessage("ApplicationName is not that of a valid module: " + this.applicationName);
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                return;
            }
            application = this.applications.getApplication(this.applicationName);
            resources = application.getResources();
            scope = "java:app/";
        }
        if (!this.poolUtil.isValidPool(resources, this.poolName, scope, report)) {
            report.setMessage("Connection Pool is not valid");
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        ArrayList<Future> instanceFlushes = new ArrayList<Future>();
        for (final Server server : this.domain.getServers().getServer()) {
            instanceFlushes.add(this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    ActionReport subReport = report.addSubActionsReport();
                    try {
                        if (!server.isRunning()) {
                            return;
                        }
                        String host = server.getAdminHost();
                        int port = server.getAdminPort();
                        ParameterMap map = new ParameterMap();
                        map.add((Object)"poolName", (Object)FlushInstancesConnectionPool.this.poolName);
                        if (FlushInstancesConnectionPool.this.applicationName != null) {
                            map.add((Object)"appname", (Object)FlushInstancesConnectionPool.this.applicationName);
                        }
                        if (FlushInstancesConnectionPool.this.moduleName != null) {
                            map.add((Object)"modulename", (Object)FlushInstancesConnectionPool.this.moduleName);
                        }
                        if (server.isDas()) {
                            CommandRunner runner = (CommandRunner)FlushInstancesConnectionPool.this.habitat.getService(CommandRunner.class, new Annotation[0]);
                            CommandRunner.CommandInvocation invocation = runner.getCommandInvocation("_flush-connection-pool", subReport, context.getSubject());
                            invocation.parameters(map);
                            invocation.execute();
                        } else {
                            ServerRemoteRestAdminCommand rac = new ServerRemoteRestAdminCommand(FlushInstancesConnectionPool.this.habitat, "_flush-connection-pool", host, port, false, "admin", null, LOGGER);
                            rac.executeCommand(map);
                            ActionReport result = rac.getActionReport();
                            subReport.setActionExitCode(result.getActionExitCode());
                            subReport.setMessage(result.getMessage());
                        }
                    }
                    catch (CommandException ex) {
                        subReport.failure(Logger.getLogger("CONNECTORS-ADMIN"), ex.getLocalizedMessage(), (Throwable)ex);
                        subReport.appendMessage(server.getName());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    }
                }
            }));
        }
        for (Future future : instanceFlushes) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (report.hasFailures()) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
    }
}

