/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.common;

import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.PermissionsXMLLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.URIParameter;
import java.security.cert.Certificate;
import javax.xml.stream.XMLStreamException;

public class PermissionsUtil {
    protected static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    protected static final String CLIENT_EE_PERMS_FILE = "javaee.client.policy";
    protected static final String CLIENT_EE_PERMS_PKG = "META-INF/javaee.client.policy";
    protected static final String CLIENT_RESTRICT_PERMS_FILE = "restrict.client.policy";
    protected static final String CLIENT_RESTRICT_PERMS_PKG = "META-INF/restrict.client.policy";

    public static PermissionCollection getClientDeclaredPermissions(ClassLoader classLoader) throws IOException {
        URL permissionsURL = classLoader.getResource(PERMISSIONS_XML);
        if (permissionsURL == null) {
            return null;
        }
        try {
            return new PermissionsXMLLoader(null, permissionsURL.openStream(), CommponentType.car).getAppDeclaredPermissions();
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static PermissionCollection getClientEEPolicy(ClassLoader classLoader) throws IOException {
        return PermissionsUtil.getClientPolicy(classLoader, CLIENT_EE_PERMS_PKG, CLIENT_EE_PERMS_FILE);
    }

    public static PermissionCollection getClientRestrictPolicy(ClassLoader classLoader) throws IOException {
        return PermissionsUtil.getClientPolicy(classLoader, CLIENT_RESTRICT_PERMS_PKG, CLIENT_RESTRICT_PERMS_FILE);
    }

    private static PermissionCollection getClientPolicy(ClassLoader classLoader, String pkgedFile, String policyFileName) throws IOException {
        URL eeClientUrl = classLoader.getResource(pkgedFile);
        if (eeClientUrl != null) {
            return PermissionsUtil.getEEPolicyPermissions(eeClientUrl);
        }
        String clientPolicyClocation = PermissionsUtil.getClientInstalledPath();
        if (clientPolicyClocation != null) {
            return PermissionsUtil.getPolicyPermissions(clientPolicyClocation + policyFileName);
        }
        return null;
    }

    private static PermissionCollection getPolicyPermissions(String policyFilename) throws IOException {
        if (!new File(policyFilename).exists()) {
            return null;
        }
        return PermissionsUtil.getEEPolicyPermissions(new URL("file:" + policyFilename));
    }

    private static PermissionCollection getEEPolicyPermissions(URL fileUrl) throws IOException {
        try {
            return Policy.getInstance("JavaPolicy", new URIParameter(fileUrl.toURI())).getPermissions(new CodeSource(new URL("file:/module/Car"), (Certificate[])null));
        }
        catch (MalformedURLException | URISyntaxException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getClientInstalledPath() {
        String policyPath = System.getProperty("java.security.policy");
        if (policyPath == null) {
            return null;
        }
        return new File(policyPath).getParent() + File.separator;
    }
}

