/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-config")
@PerLookup
@I18n(value="delete.config.command")
@RestEndpoints(value={@RestEndpoint(configBean=Config.class, opType=RestEndpoint.OpType.POST, path="delete-config", description="Delete Config", params={@RestParam(name="id", value="$parent")})})
public final class DeleteConfigCommand
implements AdminCommand {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(DeleteConfigCommand.class);
    @Param(primary=true)
    private String destConfig;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.destConfig.equals("default-config")) {
            report.setMessage(LOCAL_STRINGS.getLocalString("Config.defaultConfig", "The default configuration template named default-config cannot be deleted."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final Config config = this.domain.getConfigNamed(this.destConfig);
        if (config == null) {
            report.setMessage(LOCAL_STRINGS.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{this.destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List referenceContainers = this.domain.getReferenceContainersOf(config);
        if (!referenceContainers.isEmpty()) {
            StringBuilder namesOfContainers = new StringBuilder();
            for (ReferenceContainer referenceContainer : referenceContainers) {
                namesOfContainers.append(referenceContainer.getReference()).append(',');
            }
            report.setMessage(LOCAL_STRINGS.getLocalString("Config.inUseConfig", "Config {0} is in use and must be referenced by no server instances or clusters", new Object[]{this.destConfig, namesOfContainers}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Configs>(){

                public Object run(Configs configs) throws PropertyVetoException, TransactionFailure {
                    configs.getConfig().remove(config);
                    return null;
                }
            }, (ConfigBeanProxy)this.configs);
        }
        catch (TransactionFailure ex) {
            report.setMessage(LOCAL_STRINGS.getLocalString("Config.deleteConfigFailed", "Unable to remove config {0} ", new Object[]{config}) + " " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
        }
    }
}

