/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.jaas.PermissionFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.Subject;

public class JAASAccessControlModel
implements AccessControlModel {
    public static final String TYPE = "jaas";
    public static final String PROP_PERMISSION_FACTORY = "jaas.permissionFactory";
    public static final String PROP_PERMISSION_FACTORY_PRIVATE = "jaas.permissionFactoryPrivate";
    public static final String PROP_POLICY_PROVIDER = "jaas.policyProvider";
    private Logger logger = Globals.getLogger();
    private Properties authProps;
    private PermissionFactory permFactory = null;
    private String permFactoryPrivate = null;

    @Override
    public void initialize(String type, Properties authProperties) throws AccessControlException {
        if (!type.equals(TYPE)) {
            Object[] args = new String[]{type, TYPE, this.getClass().getName()};
            String emsg = Globals.getBrokerResources().getKString("B4072", args);
            this.logger.log(32, emsg);
            throw new AccessControlException(emsg);
        }
        this.authProps = authProperties;
        String pfclass = this.authProps.getProperty("imq.accesscontrol.jaas.permissionFactory");
        String ppclass = this.authProps.getProperty("imq.accesscontrol.jaas.policyProvider");
        try {
            if (pfclass != null) {
                this.permFactory = (PermissionFactory)Class.forName(pfclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (ppclass != null) {
                Class.forName(ppclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), (Throwable)e);
            throw new AccessControlException(e.getClass().getName() + ": " + e.getMessage());
        }
        this.permFactoryPrivate = this.authProps.getProperty("imq.accesscontrol.jaas.permissionFactoryPrivate");
        this.load();
    }

    @Override
    public void load() throws AccessControlException {
        try {
            Policy.getPolicy().refresh();
        }
        catch (SecurityException e) {
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
    }

    @Override
    public void checkConnectionPermission(Principal clientUser, String serviceName, String serviceType, Subject subject) throws AccessControlException {
        Permission perm;
        try {
            perm = this.permFactory.newPermission(this.permFactoryPrivate, "mq-conn::" + serviceType, null, null);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.toString(), (Throwable)e);
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
        try {
            this.checkPermission(subject, perm);
        }
        catch (AccessControlException e) {
            AccessControlException ace = new AccessControlException(e.getMessage() + ": " + clientUser + " [" + subject.getPrincipals() + "]");
            ace.initCause(e);
            throw ace;
        }
    }

    @Override
    public void checkDestinationPermission(Principal clientUser, String serviceName, String serviceType, Subject subject, String operation, String destination, String destinationType) throws AccessControlException {
        Permission perm;
        try {
            perm = operation.equals("create") ? this.permFactory.newPermission(this.permFactoryPrivate, "mq-auto::queue", null, null) : this.permFactory.newPermission(this.permFactoryPrivate, "mq-dest::queue:" + destination, operation, null);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.toString(), (Throwable)e);
            AccessControlException ace = new AccessControlException(e.toString());
            ace.initCause(e);
            throw ace;
        }
        try {
            this.checkPermission(subject, perm);
        }
        catch (AccessControlException e) {
            AccessControlException ace = new AccessControlException(e.getMessage() + ": " + clientUser + " [" + subject.getPrincipals() + "]");
            ace.initCause(e);
            throw ace;
        }
    }

    private void checkPermission(Subject subject, Permission p) throws AccessControlException {
        final Permission perm = p;
        Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                AccessController.checkPermission(perm);
                return null;
            }
        }, null);
    }
}

