/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class FilePool {
    public static final int POOL_UNASSIGNED = 0;
    public static final int POOL_L1 = 1;
    public static final int POOL_L2 = 2;
    public static final int POOL_L3 = 3;
    int L1allocated = 0;
    int L2allocated = 0;
    int L3allocated = 0;
    int L1capacity = 0;
    ArrayList L1pool = null;
    int L2capacity = 0;
    ArrayList L2pool = null;
    ArrayList L3pool = null;
    Hashtable active = null;
    RandomAccessStore store;
    Logger logger = Globals.getLogger();

    FilePool(RandomAccessStore store, int L1capacity, int L2capacity) {
        this.L1capacity = L1capacity;
        this.L1pool = new ArrayList(this.L1capacity);
        this.L2capacity = L2capacity;
        this.L2pool = new ArrayList(this.L2capacity);
        this.L3pool = new ArrayList();
        this.store = store;
        this.active = new Hashtable(this.L1capacity);
        if (Store.getDEBUG()) {
            this.logger.log(4, this.getClass().getName() + ": Created new file pool: L1capacity=" + L1capacity + ", L2capacity=" + L2capacity);
        }
    }

    synchronized File getFile() {
        File file = null;
        FilePoolEntry fpe = null;
        if (!this.L1pool.isEmpty()) {
            fpe = (FilePoolEntry)this.L1pool.remove(this.L1pool.size() - 1);
        } else if (!this.L2pool.isEmpty()) {
            fpe = (FilePoolEntry)this.L2pool.remove(this.L2pool.size() - 1);
        } else if (!this.L3pool.isEmpty()) {
            fpe = (FilePoolEntry)this.L3pool.remove(this.L3pool.size() - 1);
        } else {
            int n;
            if (this.store.low > 0) {
                n = this.store.low = this.store.low - 1;
            } else {
                int n2 = this.store.high;
                n = n2;
                this.store.high = n2 + 1;
            }
            int num = n;
            if (Store.getDEBUG()) {
                this.logger.log(1, "new number used for file name: " + num);
            }
            file = new File(this.store.directory, String.valueOf(num));
            fpe = new FilePoolEntry(file);
            this.assignEntryToPool(fpe);
        }
        this.active.put(fpe.getFile(), fpe);
        return fpe.getFile();
    }

    private void assignEntryToPool(FilePoolEntry fpe) {
        if (this.L1allocated < this.L1capacity) {
            ++this.L1allocated;
            fpe.setPool(1);
        } else if (this.L2allocated < this.L2capacity) {
            ++this.L2allocated;
            fpe.setPool(2);
        } else {
            ++this.L3allocated;
            fpe.setPool(3);
        }
    }

    synchronized void putFile(File file, boolean sync) {
        FilePoolEntry fpe = (FilePoolEntry)this.active.remove(file);
        RandomAccessFile rfile = null;
        if (fpe == null) {
            fpe = new FilePoolEntry(file);
            this.assignEntryToPool(fpe);
        }
        switch (fpe.getPool()) {
            case 1: {
                this.L1pool.add(fpe);
                try {
                    if (file.length() <= 0L) break;
                    rfile = new RandomAccessFile(file, "rw");
                    rfile.writeUTF("FREE");
                    if (sync) {
                        if (Store.getDEBUG_SYNC()) {
                            String msg = "FilePool putFile sync() " + file;
                            this.logger.log(4, msg);
                        }
                        rfile.getChannel().force(false);
                    }
                    rfile.close();
                }
                catch (IOException e) {
                    file.delete();
                    if (!Store.getDEBUG()) break;
                    this.logger.log(4, "Failed to tag free file " + file, (Throwable)e);
                }
                break;
            }
            case 2: {
                this.L2pool.add(fpe);
                try {
                    rfile = new RandomAccessFile(file, "rw");
                    rfile.setLength(0L);
                    if (sync) {
                        if (Store.getDEBUG_SYNC()) {
                            String msg = "FilePool putFile sync() " + file;
                            this.logger.log(4, msg);
                        }
                        rfile.getChannel().force(false);
                    }
                    rfile.close();
                }
                catch (IOException e) {
                    file.delete();
                    if (!Store.getDEBUG()) break;
                    this.logger.log(4, "Failed to truncate free file " + file, (Throwable)e);
                }
                break;
            }
            case 3: {
                this.L3pool.add(fpe);
                if (file.delete() || !Store.getDEBUG()) break;
                this.logger.log(4, "Failed to delete file " + file);
                break;
            }
        }
    }

    void clear() {
        this.L1pool.clear();
        this.L2pool.clear();
        this.L3pool.clear();
        this.L1allocated = 0;
        this.L2allocated = 0;
        this.L3allocated = 0;
        this.active.clear();
    }

    public void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(4, "FilePool.close() called; cleanup = " + cleanup);
        }
        if (!cleanup) {
            return;
        }
        Iterator iter = this.L1pool.iterator();
        FilePoolEntry fpe = null;
        File file = null;
        RandomAccessFile rfile = null;
        while (iter.hasNext()) {
            fpe = (FilePoolEntry)iter.next();
            file = fpe.getFile();
            if (file == null || file.length() == 0L) continue;
            try {
                rfile = new RandomAccessFile(file, "rw");
                rfile.setLength(0L);
                rfile.close();
            }
            catch (IOException e) {
                this.logger.log(4, "Could not truncate file: " + file, (Throwable)e);
            }
        }
    }

    public String toString() {
        return "L1 capacity=" + this.L1capacity + "  allocated=" + this.L1allocated + "  free=" + this.L1pool.size() + "\nL2 capacity=" + this.L2capacity + "  allocated=" + this.L2allocated + "  free=" + this.L2pool.size() + "\nL3 capacity=unlimited  allocated=" + this.L3allocated + "  free=" + this.L3pool.size();
    }

    void printFileInfo(PrintStream out) {
        out.println(this.toString());
    }

    void printStatistics() {
        if (Store.getDEBUG()) {
            this.logger.log(4, this.toString());
        }
    }

    public int getNumFreeFiles() {
        return this.L1pool.size() + this.L2pool.size();
    }

    public void dumpPool(PrintStream out) {
        File file;
        out.println(this.getClass().getName() + ": ");
        out.println(this.toString());
        out.print(">>>L1: ");
        for (FilePoolEntry fpe : this.L1pool) {
            file = fpe.getFile();
            out.print(file.getName() + ",");
        }
        out.print("\n>>>L2: ");
        for (FilePoolEntry fpe : this.L2pool) {
            file = fpe.getFile();
            out.print(file.getName() + ",");
        }
        out.print("\n>>>L3: ");
        for (FilePoolEntry fpe : this.L3pool) {
            file = fpe.getFile();
            out.print(file.getName() + ",");
        }
        out.print("\n");
    }

    public static class FilePoolEntry {
        private File file = null;
        private int pool = 0;

        FilePoolEntry(File file) {
            this.file = file;
            this.pool = 0;
        }

        public void setPool(int pool) {
            this.pool = pool;
        }

        public int getPool() {
            return this.pool;
        }

        public File getFile() {
            return this.file;
        }
    }
}

