/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupNotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapEntry;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

abstract class SelectThread {
    protected Logger logger = Globals.getLogger();
    protected static boolean DEBUG = GroupService.DEBUG;
    protected static final long DEF_TIMEOUT = 120000L;
    protected long TIMEOUT = Globals.getConfig().getLongProperty("imq.shared.timeout", 120000L);
    GroupRunnable parent = null;
    protected String type = "";
    int id = 0;
    private static int LASTID = 0;
    Map all_connections = Collections.synchronizedMap(new HashMap());
    List pending_connections = Collections.synchronizedList(new LinkedList());
    Set cancel_connections = new HashSet();
    HashMap key_con_map = new HashMap();
    Selector selector = null;
    boolean valid = true;
    GroupService svc = null;
    protected int INITIAL_KEY = 0;
    protected int POSSIBLE_MASK = 0;
    private MapEntry selectorListMapEntry = null;
    HashMap reasons = new HashMap();
    List cancellist = new ArrayList();

    public String getStateInfo() {
        return "[svc,item] = " + this.svc + "," + this.selectorListMapEntry + " [a,p,c] = " + this.all_connections.size() + "," + this.pending_connections.size() + "," + this.cancel_connections.size() + "]";
    }

    protected static String keyMaskToString(int mask) {
        Object str = "";
        if ((mask & 0x10) == 16) {
            str = (String)str + "OP_ACCEPT ";
        }
        if ((mask & 8) == 8) {
            str = (String)str + "OP_CONNECT ";
        }
        if ((mask & 1) == 1) {
            str = (String)str + "OP_READ ";
        }
        if ((mask & 4) == 4) {
            str = (String)str + "OP_WRITE";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("INITIAL_KEY", SelectThread.keyMaskToString(this.INITIAL_KEY));
        ht.put("POSSIBLE_MASK", SelectThread.keyMaskToString(this.POSSIBLE_MASK));
        ht.put("valid", this.valid);
        Object object = this.all_connections;
        synchronized (object) {
            ht.put("all_connections#", this.all_connections.size());
            Vector<Long> v = new Vector<Long>();
            for (IMQIPConnection con : this.all_connections.values()) {
                v.add(con.getConnectionUID().longValue());
            }
            ht.put("all_connections", v);
        }
        object = this.pending_connections;
        synchronized (object) {
            ht.put("pending_connections#", this.pending_connections.size());
        }
        object = this.cancel_connections;
        synchronized (object) {
            ht.put("cancel_connections#", this.cancel_connections.size());
        }
        if (this.selector != null) {
            IMQIPConnection ic;
            int cnt = 0;
            try {
                this.selector.wakeup();
                cnt = this.selector.selectNow();
            }
            catch (Exception ex) {
                this.logger.log(1, "Exception in select ", (Throwable)ex);
            }
            ht.put("selector(cnt)", cnt);
            Set<SelectionKey> s = this.selector.selectedKeys();
            ht.put("selector(selectedKeys#)", s.size());
            Vector<CallSite> sv = new Vector<CallSite>();
            for (SelectionKey sk : s) {
                ic = (IMQIPConnection)sk.attachment();
                sv.add((CallSite)((Object)("interest=" + SelectThread.keyMaskToString(sk.interestOps()) + " ready=" + SelectThread.keyMaskToString(sk.readyOps()) + " conuid = " + (ic == null ? "none" : String.valueOf(ic.getConnectionUID().longValue())))));
            }
            ht.put("Selector(selectedKeys)", sv);
            s = this.selector.keys();
            ht.put("selector(keys#)", s.size());
            sv = new Vector();
            for (SelectionKey sk : s) {
                ic = (IMQIPConnection)sk.attachment();
                sv.add((CallSite)((Object)("interest=" + SelectThread.keyMaskToString(sk.interestOps()) + " ready=" + SelectThread.keyMaskToString(sk.readyOps()) + " conuid = " + (ic == null ? "none" : String.valueOf(ic.getConnectionUID().longValue())))));
            }
            ht.put("Selector(keys)", sv);
        }
        return ht;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    public void assign(GroupRunnable parent) {
        this.parent = parent;
    }

    public GroupRunnable getParent() {
        return this.parent;
    }

    public void free(GroupRunnable runner) {
        this.destroy("Unknown free");
        this.parent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectThread(Service svc, MapEntry entry) throws IOException {
        this.selector = Selector.open();
        this.svc = (GroupService)svc;
        this.selectorListMapEntry = entry;
        Class<SelectThread> clazz = SelectThread.class;
        synchronized (SelectThread.class) {
            this.id = LASTID++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int size() {
        return this.all_connections.size();
    }

    public int totalSize() {
        return this.all_connections.size() + this.pending_connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewConnection(IMQIPConnection conn) throws IOException {
        List list = this.pending_connections;
        synchronized (list) {
            if (!this.isValid()) {
                throw new IOException(this + " has been destroyed ");
            }
            this.pending_connections.add(conn);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(IMQIPConnection con, String reason) throws IOException {
        SelectionKey key = null;
        HashMap hashMap = this.key_con_map;
        synchronized (hashMap) {
            key = (SelectionKey)this.key_con_map.get((Object)con.getConnectionUID());
        }
        if (key != null) {
            this.changeInterest(key, -1, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey processPendingConnection(IMQIPConnection con) throws IOException {
        if (con == null) {
            return null;
        }
        Map map = this.all_connections;
        synchronized (map) {
            this.all_connections.put(con.getConnectionUID(), con);
        }
        AbstractSelectableChannel sch = con.getChannel();
        if (sch == null) {
            throw new IOException("Connection " + con + " no longer has a valid channel");
        }
        SelectionKey key = sch.register(this.selector, this.INITIAL_KEY);
        if (key == null) {
            return null;
        }
        key.attach(con);
        GroupNotificationInfo ninfo = (GroupNotificationInfo)con.attachment();
        if (ninfo == null) {
            return null;
        }
        ninfo.setThread(this.POSSIBLE_MASK, this, key);
        HashMap hashMap = this.key_con_map;
        synchronized (hashMap) {
            this.key_con_map.put(con.getConnectionUID(), key);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeInterest(SelectionKey key, int mask, String reason) throws IOException {
        if (mask == -1) {
            Set set = this.cancel_connections;
            synchronized (set) {
                this.cancel_connections.add(key);
                this.reasons.put(key, reason);
            }
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(String reason) {
        Object object = this;
        synchronized (object) {
            this.valid = false;
        }
        if (this.selector != null) {
            try {
                object = this.all_connections;
                synchronized (object) {
                    for (IMQIPConnection con : this.all_connections.values()) {
                        this.removeConnection(con, reason);
                    }
                }
                this.selector.close();
            }
            catch (IOException ex) {
                this.logger.log(4, "exception closing", (Throwable)ex);
            }
            finally {
                this.selector = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processThread() throws Exception {
        while (true) {
            if (!this.valid) {
                this.logger.log(4, "SelectThread " + this + " no longer valid");
                break;
            }
            IMQIPConnection con = null;
            List list = this.pending_connections;
            synchronized (list) {
                if (this.pending_connections.size() <= 0) {
                    break;
                }
                con = (IMQIPConnection)this.pending_connections.remove(0);
            }
            try {
                this.processPendingConnection(con);
            }
            catch (IOException ex) {
                this.logger.logStack(4, "Exception on pending con " + con + " : can not process", (Throwable)ex);
            }
        }
        HashMap cancelreasons = null;
        Set ex = this.cancel_connections;
        synchronized (ex) {
            if (this.cancel_connections.size() > 0) {
                cancelreasons = new HashMap();
                if (this.reasons != null) {
                    cancelreasons.putAll(this.reasons);
                    this.reasons.clear();
                }
                this.cancellist.clear();
                this.cancellist.addAll(this.cancel_connections);
                this.cancel_connections.clear();
            }
        }
        if (this.cancellist.size() > 0) {
            for (SelectionKey key : this.cancellist) {
                IMQIPConnection con = (IMQIPConnection)key.attachment();
                SelectableChannel chl = key.channel();
                String reason = cancelreasons == null ? "unknown" : (String)cancelreasons.remove(key);
                try {
                    key.cancel();
                }
                catch (Exception ex2) {
                    this.logger.log(4, "exception cancling key", (Throwable)ex2);
                }
                try {
                    if (chl != null) {
                        Socket soc = ((SocketChannel)chl).socket();
                        chl.close();
                        soc.close();
                    }
                }
                catch (Exception ex3) {
                    this.logger.log(4, "closing ", (Throwable)ex3);
                }
                try {
                    Object ex3 = this.pending_connections;
                    synchronized (ex3) {
                        this.pending_connections.remove(con);
                    }
                    ex3 = this.all_connections;
                    synchronized (ex3) {
                        this.all_connections.remove((Object)con.getConnectionUID());
                    }
                    ex3 = this.key_con_map;
                    synchronized (ex3) {
                        this.key_con_map.remove((Object)con.getConnectionUID());
                    }
                }
                catch (Exception ex4) {
                    this.logger.log(4, "closing ", (Throwable)ex4);
                }
                try {
                    con.destroyConnection(false, 5, reason);
                }
                catch (Exception ex5) {
                    this.logger.log(4, "destroying con", (Throwable)ex5);
                }
            }
            this.cancellist.clear();
        }
        if (this.valid) {
            try {
                this.process();
            }
            catch (Exception ex6) {
                this.logger.logStack(8, "Exception processing " + this, (Throwable)ex6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Map map = this.all_connections;
        synchronized (map) {
            List list = this.pending_connections;
            synchronized (list) {
                SelectThread selectThread = this;
                synchronized (selectThread) {
                    return this.valid && (!this.all_connections.isEmpty() || !this.pending_connections.isEmpty());
                }
            }
        }
    }

    protected abstract void wakeup() throws IOException;

    protected abstract void process() throws IOException;

    public String toString() {
        return "SelectThread[" + this.type + ":" + this.id + "]";
    }
}

