/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompConnectionImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompDestinationImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSenderSession;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSessionImpl;
import com.sun.messaging.jmq.jmsservice.Consumer;
import com.sun.messaging.jmq.jmsservice.ConsumerClosedNoDeliveryException;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StompTransactedSession
extends StompSenderSession {
    private String lastRolledbackTID = null;
    private String tid = null;
    private long transactionId = 0L;
    private Map<String, TransactedSubscriber> subscribers = Collections.synchronizedMap(new HashMap());
    private List<SubscribedMessage> unackqueue = new ArrayList<SubscribedMessage>();

    public StompTransactedSession(StompConnectionImpl stompc) throws Exception {
        super(stompc, true);
    }

    @Override
    public String toString() {
        return "[StompTransactedSession@" + this.hashCode() + ", tid=" + this.tid + "[" + this.transactionId + "], lastRB=" + this.lastRolledbackTID + ", subs=" + this.subscribers.size() + ", unacks=" + this.unackqueue.size() + "]";
    }

    public synchronized String getLastRolledbackStompTransactionId() {
        return this.lastRolledbackTID;
    }

    @Override
    protected synchronized void closeSubscribers() {
        TransactedSubscriber sub = null;
        for (String subid : this.subscribers.keySet()) {
            sub = this.subscribers.get(subid);
            try {
                sub.close(false);
            }
            catch (Exception e) {
                if ((this.isClosing() || sub.isClosing()) && !this.getDEBUG()) continue;
                logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected synchronized long getTransactionId() {
        return this.transactionId;
    }

    public synchronized String getStompTransactionId() {
        return this.tid;
    }

    public synchronized void setStompTransactionId(String tid) {
        this.tid = tid;
        if (tid == null) {
            this.transactionId = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String subid, String msgid, boolean nack) throws Exception {
        this.checkSession();
        String cmd = nack ? "NACK " : "ACK ";
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (this.getStompTransactionId() == null) {
                throw new StompProtocolException("Transacted " + cmd + "[" + subid + ", " + msgid + "] no current transaction");
            }
            TransactedSubscriber sub = this.subscribers.get(subid);
            if (sub == null) {
                throw new StompProtocolException("Subscription " + subid + " not found to transacted " + cmd + " message " + msgid);
            }
            SysMessageID sysid = SysMessageID.get((String)msgid);
            SubscribedMessage sm2 = new SubscribedMessage(subid, sysid);
            int index = this.unackqueue.indexOf(sm2);
            if (index == -1) {
                throw new StompProtocolException("Message " + msgid + " for subscription " + subid + " not found in transaction " + this.tid);
            }
            ArrayList<SubscribedMessage> acks = new ArrayList<SubscribedMessage>();
            if (nack) {
                acks.add(sm2);
            } else {
                for (int i = 0; i <= index; ++i) {
                    sm2 = this.unackqueue.get(i);
                    if (!sm2.subid.equals(subid)) continue;
                    acks.add(sm2);
                }
            }
            for (SubscribedMessage sm2 : acks) {
                if (!nack) {
                    this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, sm2.consumerId, sm2.sysid, this.transactionId, JMSService.MessageAckType.ACKNOWLEDGE);
                } else {
                    this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, sm2.consumerId, sm2.sysid, this.transactionId, JMSService.MessageAckType.DEAD, 1, "STOMP:NACK", null);
                }
                this.unackqueue.remove(sm2);
            }
            return;
        }
    }

    public void ack10(String subidPrefix, String msgid) throws Exception {
        throw new StompProtocolException("STOMP 1.0 no subscription id ACK is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StompSubscriber createSubscriber(String subid, StompDestination d, String selector, String duraname, boolean nolocal, StompOutputHandler out) throws Exception {
        this.checkSession();
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (this.subscribers.get(subid) != null) {
                throw new StompProtocolException("Subscriber " + subid + " already exist in transacted session " + this);
            }
            String stompdest = this.stompconn.getProtocolHandler().toStompFrameDestination(d, false);
            Destination dest = ((StompDestinationImpl)d).getDestination();
            JMSServiceReply reply = null;
            try {
                reply = this.jmsservice.createDestination(this.connectionId, dest);
            }
            catch (JMSServiceException jmsse) {
                JMSServiceReply.Status status = jmsse.getJMSServiceReply().getStatus();
                if (status == JMSServiceReply.Status.CONFLICT) {
                    if (this.getDEBUG()) {
                        logger.log(8, "Destination " + stompdest + " already exist");
                    }
                }
                throw jmsse;
            }
            reply = this.jmsservice.startConnection(this.connectionId);
            reply = this.jmsservice.addConsumer(this.connectionId, this.sessionId, dest, selector, duraname, duraname != null, false, false, this.stompconn.getClientID(), nolocal);
            long consumerId = reply.getJMQConsumerID();
            TransactedSubscriber sub = new TransactedSubscriber(subid, consumerId, duraname, stompdest, out);
            this.subscribers.put(subid, sub);
            return sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(String stomptid) throws Exception {
        this.checkSession();
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (this.getDEBUG()) {
                logger.log(8, "Begin transaction " + stomptid + " in [" + this + "]");
            }
            if (this.tid != null) {
                throw new StompProtocolException("Transaction session has current transaction " + this.tid);
            }
            JMSServiceReply reply = this.jmsservice.startTransaction(this.connectionId, this.sessionId, null, 0, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            this.transactionId = reply.getJMQTransactionID();
            this.setStompTransactionId(stomptid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Exception {
        this.checkSession();
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (this.getStompTransactionId() == null) {
                throw new StompProtocolException("Commit no current transaction in session " + this);
            }
            if (this.getDEBUG()) {
                logger.log(8, "Committing transaction " + this.tid + " in [" + this + "]");
            }
            try {
                this.jmsservice.commitTransaction(this.connectionId, this.transactionId, null, 0);
            }
            catch (Exception e) {
                String emsg = "Exception in committing transaction " + this.tid;
                logger.logStack(32, emsg, (Throwable)e);
                try {
                    this.rollback();
                    this.lastRolledbackTID = this.tid;
                }
                catch (Exception ee) {
                    logger.logStack(16, "Failed to rollback transaction " + this.tid + " after commit failure", (Throwable)ee);
                }
                finally {
                    throw new StompProtocolException(emsg, e);
                }
            }
            finally {
                this.setStompTransactionId(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws Exception {
        this.checkSession();
        StompTransactedSession stompTransactedSession = this;
        synchronized (stompTransactedSession) {
            if (this.getStompTransactionId() == null) {
                throw new StompProtocolException("Rollback no current transaction in session " + this);
            }
            if (this.getDEBUG()) {
                logger.log(8, "Rollback transaction " + this.tid + " in [" + this + "]");
            }
            try {
                this.jmsservice.rollbackTransaction(this.connectionId, this.transactionId, null, true, true);
            }
            finally {
                this.lastRolledbackTID = this.tid;
                this.setStompTransactionId(null);
            }
        }
    }

    public synchronized String closeSubscriber(String subid, String duraname) throws Exception {
        TransactedSubscriber sub = null;
        if (duraname == null) {
            sub = this.subscribers.get(subid);
            if (sub == null) {
                return null;
            }
            sub.close(false);
            this.subscribers.remove(subid);
            return subid;
        }
        String dn = null;
        for (String id : this.subscribers.keySet()) {
            sub = this.subscribers.get(id);
            dn = sub.duraName;
            if (dn == null || !dn.equals(duraname)) continue;
            break;
        }
        if (sub != null) {
            sub.close(true);
            this.subscribers.remove(sub.subid);
            return sub.subid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessage(TransactedSubscriber sub, SubscribedMessage sm, StompOutputHandler out) throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closing || this.closed || this.stompconn.isClosed() || sub.isClosing()) {
                throw new ConsumerClosedNoDeliveryException("StompSubscriber " + this + " is closed");
            }
        }
        object = this;
        synchronized (object) {
            this.unackqueue.add(sm);
            out.sendToClient(sm.msg, this.stompconn.getProtocolHandler(), null);
        }
    }

    static class SubscribedMessage {
        String subid = null;
        long consumerId = 0L;
        SysMessageID sysid = null;
        StompFrameMessage msg = null;

        SubscribedMessage(String subid, long consumerId, SysMessageID sysid, StompFrameMessage msg) {
            this.subid = subid;
            this.consumerId = consumerId;
            this.sysid = sysid;
            this.msg = msg;
        }

        SubscribedMessage(String subid, SysMessageID sysid) {
            this.subid = subid;
            this.sysid = sysid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubscribedMessage)) {
                return false;
            }
            SubscribedMessage that = (SubscribedMessage)obj;
            return that.subid.equals(this.subid) && that.sysid.equals((Object)this.sysid);
        }

        public int hashCode() {
            return this.subid.hashCode() + this.sysid.hashCode();
        }
    }

    private class TransactedSubscriber
    implements Consumer,
    StompSubscriber {
        String subid = null;
        long consumerId = 0L;
        String duraName = null;
        String stompdest = null;
        StompOutputHandler out = null;
        SubscribedMessage lastseen = null;
        boolean subscriberClosing = false;
        boolean subscriberClosed = false;

        TransactedSubscriber(String subid, long id, String duraname, String stompdest, StompOutputHandler out) {
            this.subid = subid;
            this.consumerId = id;
            this.duraName = duraname;
            this.stompdest = stompdest;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosing() {
            Object object = StompTransactedSession.this.closeLock;
            synchronized (object) {
                return this.subscriberClosing || this.subscriberClosed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean unsubscribe) throws Exception {
            SysMessageID lastsysid = null;
            Object object = StompTransactedSession.this.closeLock;
            synchronized (object) {
                if (this.subscriberClosed) {
                    return;
                }
                this.subscriberClosing = true;
                lastsysid = this.lastseen.sysid;
            }
            StompTransactedSession.this.jmsservice.deleteConsumer(StompTransactedSession.this.connectionId, StompTransactedSession.this.sessionId, this.consumerId, lastsysid, true, unsubscribe ? this.duraName : null, StompTransactedSession.this.stompconn.getClientID());
            object = StompTransactedSession.this.closeLock;
            synchronized (object) {
                this.subscriberClosed = true;
            }
            SubscribedMessage sm = null;
            Iterator<SubscribedMessage> itr = null;
            StompTransactedSession stompTransactedSession = StompTransactedSession.this;
            synchronized (stompTransactedSession) {
                itr = StompTransactedSession.this.unackqueue.iterator();
                while (itr.hasNext()) {
                    sm = itr.next();
                    if (!sm.subid.equals(this.subid)) continue;
                    itr.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JMSAck deliver(JMSPacket msgpkt) throws ConsumerClosedNoDeliveryException {
            if (this.isClosing() || StompTransactedSession.this.stompconn.isClosed()) {
                throw new ConsumerClosedNoDeliveryException("StompSubscriber " + this + " is closed");
            }
            try {
                StompFrameMessage msg = StompTransactedSession.this.toStompFrameMessage(this.subid, this.stompdest, msgpkt.getPacket(), true);
                if (StompTransactedSession.this.getDEBUG()) {
                    StompSessionImpl.logger.log(8, " SEND message " + msg + " for " + this.toString());
                }
                SubscribedMessage sm = new SubscribedMessage(this.subid, this.consumerId, msgpkt.getPacket().getSysMessageID(), msg);
                StompTransactedSession.this.deliverMessage(this, sm, this.out);
                Object object = StompTransactedSession.this.closeLock;
                synchronized (object) {
                    this.lastseen = sm;
                }
            }
            catch (Exception e) {
                if (e instanceof ConsumerClosedNoDeliveryException) {
                    throw (ConsumerClosedNoDeliveryException)e;
                }
                StompSessionImpl.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
            return null;
        }

        @Override
        public void startDelivery() throws Exception {
            StompTransactedSession.this.jmsservice.setConsumerAsync(StompTransactedSession.this.connectionId, StompTransactedSession.this.sessionId, this.consumerId, this);
        }
    }
}

