/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobStatusEvent
implements IdentifiedDataSerializable {
    private long jobId;
    private JobStatus previousStatus;
    private JobStatus newStatus;
    private String description;
    private boolean userRequested;

    public JobStatusEvent() {
    }

    public JobStatusEvent(long jobId, @Nonnull JobStatus previousStatus, @Nonnull JobStatus newStatus, @Nullable String description, boolean userRequested) {
        this.jobId = jobId;
        this.previousStatus = previousStatus;
        this.newStatus = newStatus;
        this.description = description;
        this.userRequested = userRequested;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public JobStatus getPreviousStatus() {
        return this.previousStatus;
    }

    @Nonnull
    public JobStatus getNewStatus() {
        return this.newStatus;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isUserRequested() {
        return this.userRequested;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeObject((Object)this.previousStatus);
        out.writeObject((Object)this.newStatus);
        out.writeString(this.description);
        out.writeBoolean(this.userRequested);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.previousStatus = (JobStatus)((Object)in.readObject());
        this.newStatus = (JobStatus)((Object)in.readObject());
        this.description = in.readString();
        this.userRequested = in.readBoolean();
    }

    public String toString() {
        return "JobStatusEvent{jobId=" + Util.idToString(this.jobId) + ", previousStatus=" + (Object)((Object)this.previousStatus) + ", newStatus=" + (Object)((Object)this.newStatus) + ", description=" + this.description + ", userRequested=" + this.userRequested + "}";
    }
}

