/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IOUtil {
    private static final int BUFFER_SIZE = 16384;

    private IOUtil() {
    }

    public static void packDirectoryIntoZip(@Nonnull Path baseDir, @Nonnull OutputStream destination) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(destination);
             Stream<Path> fileStream = Files.walk(baseDir, new FileVisitOption[0]);){
            fileStream.forEach(p -> {
                try {
                    if (Files.isHidden(p) || p == baseDir) {
                        return;
                    }
                    String relativePath = baseDir.relativize((Path)p).toString();
                    boolean directory = Files.isDirectory(p, new LinkOption[0]);
                    relativePath = directory ? relativePath + "/" : relativePath;
                    zipOut.putNextEntry(new ZipEntry(relativePath));
                    if (!directory) {
                        Files.copy(p, zipOut);
                    }
                    zipOut.closeEntry();
                }
                catch (IOException e) {
                    throw ExceptionUtil.sneakyThrow(e);
                }
            });
        }
    }

    public static void packStreamIntoZip(@Nonnull InputStream source, @Nonnull OutputStream destination, @Nonnull String fileName) throws IOException {
        try (ZipOutputStream dstZipStream = new ZipOutputStream(destination);){
            dstZipStream.putNextEntry(new ZipEntry(fileName));
            IOUtil.copyStream(source, dstZipStream);
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buf = new byte[16384];
        while ((readCount = in.read(buf)) > 0) {
            out.write(buf, 0, readCount);
        }
    }

    @Nonnull
    public static byte[] readFully(@Nonnull InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            byte[] b = new byte[16384];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void unzip(InputStream is, Path targetDir) throws IOException {
        targetDir = targetDir.toAbsolutePath();
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName()).normalize();
                if (!resolvedPath.startsWith(targetDir)) {
                    throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                }
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Path dir = resolvedPath.getParent();
                assert (dir != null) : "null parent: " + resolvedPath;
                Files.createDirectories(dir, new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
    }

    @Nullable
    public static String fileNameFromUrl(@Nullable URL url) {
        String fnamePath;
        if (url == null || (fnamePath = url.getPath()) == null) {
            return null;
        }
        int lastSlash = fnamePath.lastIndexOf(47);
        return lastSlash < 0 ? fnamePath : fnamePath.substring(lastSlash + 1);
    }

    @Nonnull
    public static String canonicalName(String directory) {
        return Util.uncheckCall(() -> new File(directory).getCanonicalPath());
    }
}

