/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.tenantcontrol.DestroyEventContext;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import com.hazelcast.spi.tenantcontrol.Tenantable;
import fish.payara.nucleus.hazelcast.PayaraHazelcastTenantFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;

public class PayaraHazelcastTenant
implements TenantControl,
DataSerializable {
    private final JavaEEContextUtil ctxUtil = (JavaEEContextUtil)Globals.getDefaultHabitat().getService(JavaEEContextUtil.class, new Annotation[0]);
    private final Events events = (Events)Globals.getDefaultHabitat().getService(Events.class, new Annotation[0]);
    private final InvocationManager invMgr = (InvocationManager)Globals.getDefaultHabitat().getService(InvocationManager.class, new Annotation[0]);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private static final Logger log = Logger.getLogger(PayaraHazelcastTenant.class.getName());
    private static final Map<String, Integer> blockedCounts = new ConcurrentHashMap<String, Integer>();
    private EventListenerImpl destroyEventListener;
    private JavaEEContextUtil.Instance contextInstance;
    private String moduleName;

    PayaraHazelcastTenant() {
        if (this.invMgr.getCurrentInvocation() != null) {
            this.contextInstance = this.ctxUtil.currentInvocation();
            this.moduleName = VersioningUtils.getUntaggedName((String)this.invMgr.getCurrentInvocation().getModuleName());
        } else {
            this.contextInstance = this.ctxUtil.empty();
        }
    }

    public void registerObject(DestroyEventContext destroyContext) {
        this.destroyEventListener = new EventListenerImpl(destroyContext);
        this.events.register((EventListener)this.destroyEventListener);
    }

    public void unregisterObject() {
        this.events.unregister((EventListener)this.destroyEventListener);
        this.destroyEventListener = null;
    }

    public TenantControl.Closeable setTenant() {
        return () -> ((JavaEEContextUtil.Context)this.contextInstance.pushRequestContext()).close();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.contextInstance);
        out.writeString(this.moduleName);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.contextInstance = (JavaEEContextUtil.Instance)in.readObject();
        this.moduleName = in.readString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(Tenantable tenantable) {
        if (PayaraHazelcastTenantFactory.blockingDisabled || this.contextInstance.isLoaded()) {
            return true;
        }
        if (!tenantable.requiresTenantContext() || this.tenantNotRequired(tenantable)) {
            return true;
        }
        this.lock.lock();
        try {
            String componentId = this.contextInstance.getInstanceComponentId();
            int unavailableCount = blockedCounts.compute(componentId, (k, v) -> {
                int n;
                if (v == null) {
                    n = 0;
                } else {
                    v = v + 1;
                    n = v;
                }
                return n;
            });
            log.log(unavailableCount > 100 ? Level.INFO : Level.FINEST, String.format("BLOCKED: tenant not available: %s, module %s, Operation: %s", componentId, this.moduleName, tenantable.getClass().getName()));
            if (unavailableCount > 100) {
                blockedCounts.remove(componentId);
            }
            this.condition.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public void clearThreadContext() {
        if (!this.invMgr.isInvocationStackEmpty()) {
            log.warning(String.format("clearThreadContext - non-empty invocations: %s", this.invMgr.getAllInvocations().toString()));
            this.invMgr.putAllInvocations(null);
        }
    }

    private boolean tenantNotRequired(Tenantable tenantable) {
        switch (tenantable.getClass().getSimpleName()) {
            case "DeleteOperation": {
                return true;
            }
        }
        return false;
    }

    private void tenantUnavailable() {
        this.contextInstance.clearInstanceInvocation();
    }

    private class EventListenerImpl
    implements EventListener {
        private final DestroyEventContext destroyEvent;

        private EventListenerImpl(DestroyEventContext event) {
            this.destroyEvent = event;
        }

        public void event(EventListener.Event<?> payaraEvent) {
            if (payaraEvent.is(Deployment.MODULE_STARTED)) {
                if (PayaraHazelcastTenant.this.ctxUtil.moduleMatches((ModuleInfo)payaraEvent.hook(), PayaraHazelcastTenant.this.moduleName)) {
                    PayaraHazelcastTenant.this.lock.lock();
                    try {
                        PayaraHazelcastTenant.this.condition.signalAll();
                    }
                    finally {
                        PayaraHazelcastTenant.this.lock.unlock();
                    }
                }
            } else if (payaraEvent.is(Deployment.MODULE_STOPPED) && PayaraHazelcastTenant.this.ctxUtil.moduleMatches((ModuleInfo)payaraEvent.hook(), PayaraHazelcastTenant.this.moduleName)) {
                PayaraHazelcastTenant.this.tenantUnavailable();
                this.destroyEvent.tenantUnavailable();
            }
        }
    }
}

