/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.ByteBufferWrapper;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.util.LoggerWrapper;
import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class StompFrameMessageImpl
extends StompFrameMessage {
    private static final StompBridgeResources sbr = StompServer.getStompBridgeResources();
    private static final StompFrameMessageFactory factory = new StompFrameMessageFactoryImpl();

    protected static StompFrameMessageFactory getFactory() {
        return factory;
    }

    protected StompFrameMessageImpl(StompFrameMessage.Command cmd, LoggerWrapper logger) {
        super(cmd, logger);
    }

    public static StompFrameMessageImpl parseCommand(Buffer buf, LoggerWrapper logger) throws Exception {
        return (StompFrameMessageImpl)StompFrameMessage.parseCommand(new ByteBufferWrapperImpl(buf), logger, factory);
    }

    public void parseHeader(Buffer buf) throws Exception {
        super.parseHeader(new ByteBufferWrapperImpl(buf));
    }

    public void readBody(Buffer buf) throws Exception {
        super.readBody(new ByteBufferWrapperImpl(buf));
    }

    public void readNULL(Buffer buf) throws Exception {
        super.readNULL(new ByteBufferWrapperImpl(buf));
    }

    @Override
    protected OutputStream newBufferOutputStream(Object obj) throws IOException {
        MemoryManager mm = (MemoryManager)obj;
        return new BufferOutputStream(mm);
    }

    @Override
    protected ByteBufferWrapper getBuffer(OutputStream os) throws IOException {
        BufferOutputStream bos = (BufferOutputStream)os;
        return new ByteBufferWrapperImpl(bos.getBuffer());
    }

    @Override
    protected String getKStringX_CANNOT_PARSE_BODY_TO_TEXT(String cmd, String emsg) {
        return sbr.getKString("BSS4010", cmd, emsg);
    }

    @Override
    protected String getKStringX_HEADER_NOT_SPECIFIED_FOR(String headerName, String cmd) {
        return sbr.getKString("BSS4020", headerName, cmd);
    }

    @Override
    protected String getKStringX_INVALID_HEADER_VALUE(String headerValue, String cmd) {
        return sbr.getKString("BSS4012", headerValue, cmd);
    }

    @Override
    protected String getKStringX_INVALID_HEADER(String headerName) {
        return sbr.getKString("BSS4013", headerName);
    }

    @Override
    protected String getKStringX_MAX_HEADERS_EXCEEDED(int maxHeaders) {
        return sbr.getKString("BSS4014", maxHeaders);
    }

    @Override
    protected String getKStringX_EXCEPTION_PARSE_HEADER(String headerName, String emsg) {
        return sbr.getKString("BSS4015", headerName, emsg);
    }

    @Override
    protected String getKStringX_NO_NULL_TERMINATOR(String contentlen) {
        return sbr.getKString("BSS4016", contentlen);
    }

    @Override
    protected String getKStringX_UNKNOWN_STOMP_CMD(String cmd) {
        return sbr.getKString("BSS4038", cmd);
    }

    @Override
    protected String getKStringX_MAX_LINELEN_EXCEEDED(int maxbytes) {
        return sbr.getKString("BSS4017", maxbytes);
    }

    private static class ByteBufferWrapperImpl
    implements ByteBufferWrapper<Buffer> {
        private Buffer buf = null;

        ByteBufferWrapperImpl(Buffer buf) {
            this.buf = buf;
        }

        @Override
        public Buffer getWrapped() {
            return this.buf;
        }

        @Override
        public int position() {
            return this.buf.position();
        }

        @Override
        public ByteBufferWrapper position(int newPosition) {
            this.buf.position(newPosition);
            return this;
        }

        @Override
        public boolean hasRemaining() {
            return this.buf.hasRemaining();
        }

        @Override
        public int remaining() {
            return this.buf.remaining();
        }

        @Override
        public ByteBufferWrapper flip() {
            this.buf.flip();
            return this;
        }

        @Override
        public byte get() {
            return this.buf.get();
        }
    }

    static class StompFrameMessageFactoryImpl
    implements StompFrameMessageFactory {
        StompFrameMessageFactoryImpl() {
        }

        @Override
        public StompFrameMessage newStompFrameMessage(StompFrameMessage.Command cmd, LoggerWrapper logger) {
            return new StompFrameMessageImpl(cmd, logger);
        }
    }
}

