/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MQResourceBundle
extends ResourceBundle {
    public static final String NL = System.getProperty("line.separator", "\n");
    private ResourceBundle rb = null;
    private boolean convertEOL = false;
    private static final String UnixEOL = "\n";
    private HashMap<String, Object> cache = null;
    private static boolean DEBUG = false;

    public MQResourceBundle(ResourceBundle rb) {
        this.rb = rb;
        String s = System.getProperty("line.separator");
        if (!s.equals(UnixEOL)) {
            this.convertEOL = true;
            this.cache = new HashMap();
            if (DEBUG) {
                System.out.println(this.getClass().getName() + ": Will convert messages to use native EOL.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleGetObject(String key) {
        if (this.convertEOL) {
            Object o = null;
            HashMap<String, Object> hashMap = this.cache;
            synchronized (hashMap) {
                o = this.cache.get(key);
                if (o == null && (o = this.rb.getObject(key)) instanceof String) {
                    o = MQResourceBundle.unix2native((String)o);
                    this.cache.put(key, o);
                }
            }
            return o;
        }
        return this.rb.getObject(key);
    }

    public String getString(String key, Object arg) throws MissingResourceException {
        if (arg instanceof Object[]) {
            return MessageFormat.format(this.getString(key), (Object[])arg);
        }
        Object[] args = new Object[]{arg};
        return MessageFormat.format(this.getString(key), args);
    }

    public String getString(String key, Object arg1, Object arg2) throws MissingResourceException {
        Object[] args = new Object[]{arg1, arg2};
        return MessageFormat.format(this.getString(key), args);
    }

    public String getString(String key, Object[] args) throws MissingResourceException {
        return MessageFormat.format(this.getString(key), args);
    }

    public String getKString(String key) throws MissingResourceException {
        return "[" + key + "]: " + this.getString(key);
    }

    public String getKTString(String key) throws MissingResourceException {
        return "[" + key + "]: [" + Thread.currentThread() + "]" + this.getString(key);
    }

    public String getKString(String key, Object arg) throws MissingResourceException {
        return "[" + key + "]: " + this.getString(key, arg);
    }

    public String getKString(String key, Object arg1, Object arg2) throws MissingResourceException {
        return "[" + key + "]: " + this.getString(key, arg1, arg2);
    }

    public String getKTString(String key, Object arg1, Object arg2) throws MissingResourceException {
        return "[" + key + "]: [" + Thread.currentThread() + "]" + this.getString(key, arg1, arg2);
    }

    public String getKString(String key, Object[] args) throws MissingResourceException {
        return "[" + key + "]: " + this.getString(key, args);
    }

    public String getKTString(String key, Object[] args) throws MissingResourceException {
        return "[" + key + "]: [" + Thread.currentThread() + "]" + this.getString(key, args);
    }

    public char getChar(String key) throws MissingResourceException {
        char c;
        String s = this.getString(key);
        try {
            c = s.charAt(0);
        }
        catch (Exception e) {
            c = '\u0000';
        }
        return c;
    }

    public String getCString(String key) throws MissingResourceException {
        return this.getString(key) + ":";
    }

    public static String unix2native(String s) {
        StringBuffer sb = null;
        String EOL = System.getProperty("line.separator");
        int start = 0;
        if (s == null) {
            return "<null>";
        }
        if (EOL.equals(UnixEOL)) {
            return s;
        }
        for (int n = 0; n < s.length(); ++n) {
            if (s.charAt(n) != '\n') continue;
            if (sb == null) {
                sb = new StringBuffer(2 * s.length());
            }
            sb.append(s.substring(start, n));
            sb.append(EOL);
            start = n + 1;
        }
        if (sb != null) {
            if (start < s.length()) {
                sb.append(s.substring(start, s.length()));
            }
            return sb.toString();
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(": convertEOL=").append(this.convertEOL);
        if (this.convertEOL && this.cache != null) {
            sb.append(" cache=").append(this.cache);
            sb.append('\n');
        }
        sb.append(" resourceBundle=").append(this.rb);
        return sb.toString();
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.rb.getKeys();
    }

    @Override
    public Locale getLocale() {
        return this.rb.getLocale();
    }
}

