/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.environment.warning.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.appserver.environment.warning.config.EnvironmentWarningConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-environment-warning-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-environment-warning-configuration", description="Sets the Environment Warning Configuration")})
public class SetEnvironmentWarningConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Param(name="enabled", alias="Enabled", optional=true)
    private Boolean enabled;
    @Param(name="message", alias="Message", optional=true)
    private String message;
    @Param(name="backgroundColour", alias="BackgroundColour", optional=true)
    private String backgroundColour;
    @Param(name="textColour", alias="TextColour", optional=true)
    private String textColour;
    private final String target = "server-config";

    public void execute(AdminCommandContext acc) {
        Config config = this.targetUtil.getConfig("server-config");
        ActionReport actionReport = acc.getActionReport();
        EnvironmentWarningConfiguration environmentWarningConfiguration = (EnvironmentWarningConfiguration)config.getExtensionByType(EnvironmentWarningConfiguration.class);
        if (environmentWarningConfiguration != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<EnvironmentWarningConfiguration>(){

                    public Object run(EnvironmentWarningConfiguration config) throws PropertyVetoException {
                        if (SetEnvironmentWarningConfigurationCommand.this.enabled != null) {
                            config.setEnabled(SetEnvironmentWarningConfigurationCommand.this.enabled);
                        }
                        if (SetEnvironmentWarningConfigurationCommand.this.message != null) {
                            config.setMessage(SetEnvironmentWarningConfigurationCommand.this.message);
                        }
                        if (SetEnvironmentWarningConfigurationCommand.this.backgroundColour != null) {
                            if (SetEnvironmentWarningConfigurationCommand.this.backgroundColour.matches("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")) {
                                config.setBackgroundColour(SetEnvironmentWarningConfigurationCommand.this.backgroundColour);
                            } else {
                                throw new PropertyVetoException("Invalid data for background colour, must be a hex value.", new PropertyChangeEvent(config, "backgroundColour", config.getBackgroundColour(), SetEnvironmentWarningConfigurationCommand.this.backgroundColour));
                            }
                        }
                        if (SetEnvironmentWarningConfigurationCommand.this.textColour != null) {
                            if (SetEnvironmentWarningConfigurationCommand.this.textColour.matches("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$")) {
                                config.setTextColour(SetEnvironmentWarningConfigurationCommand.this.textColour);
                            } else {
                                throw new PropertyVetoException("Invalid data for text colour, must be a hex value.", new PropertyChangeEvent(config, "textColour", config.getTextColour(), SetEnvironmentWarningConfigurationCommand.this.textColour));
                            }
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)environmentWarningConfiguration);
            }
            catch (TransactionFailure ex) {
                actionReport.failure(Logger.getLogger(SetEnvironmentWarningConfigurationCommand.class.getName()), "Failed to update configuration", (Throwable)ex);
            }
        }
    }
}

