/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.context;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.stream.Stream;
import org.glassfish.internal.api.ContextProducer;
import org.glassfish.internal.api.Contextualizer;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.jvnet.hk2.annotations.Service;

@Service
public class ContextualizerImpl
implements Contextualizer {
    @Inject
    private JavaEEContextUtil ctxUtil;

    public <T> T contextualize(T object, Class<T> intf) {
        return this.contextualize(object, (ContextProducer.Instance)this.ctxUtil.currentInvocation(), Stream.of(intf));
    }

    public <T> T contextualize(T object, ContextProducer.Instance context, Class<T> intf) {
        return this.contextualize(object, context, Stream.of(intf));
    }

    public <T> T contextualize(T object, ContextProducer.Instance context, Stream<Class<?>> interfaces) {
        return (T)Proxy.newProxyInstance(this.ctxUtil.getInvocationClassLoader(), (Class[])interfaces.toArray(Class[]::new), (InvocationHandler)new InvocationHandlerImpl(context, object));
    }

    public class InvocationHandlerImpl
    implements InvocationHandler {
        private final ContextProducer.Instance inv;
        private final Object delegate;
        private boolean ignore;

        private InvocationHandlerImpl(ContextProducer.Instance currentInvocation, Object delegate) {
            this.inv = currentInvocation;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (ContextProducer.Context ctx = this.inv.pushRequestContext();){
                if (!this.ignore && ctx.isValid()) {
                    Object object = method.invoke(this.delegate, args);
                    return object;
                }
                this.ignore = true;
                Object var5_6 = null;
                return var5_6;
            }
        }
    }
}

