/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing;

import fish.payara.opentracing.OpenTelemetryService;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.glassfish.internal.api.Globals;

@ApplicationScoped
public class OpenTelemetryTracerProducer {
    private final OpenTelemetryService openTelemetry = (OpenTelemetryService)Globals.getDefaultBaseServiceLocator().getService(OpenTelemetryService.class, new Annotation[0]);
    private static final Baggage FORWARDED_BAGGAGE = new ForwardedBaggage();
    private static final Span FORWARDED_SPAN = new ForwardedSpan();

    @Produces
    @ApplicationScoped
    Tracer createTracer() {
        return this.openTelemetry.getCurrentTracer();
    }

    @Produces
    Baggage currentBaggage() {
        return FORWARDED_BAGGAGE;
    }

    @Produces
    Span currentSpan() {
        return FORWARDED_SPAN;
    }

    @Produces
    @ApplicationScoped
    OpenTelemetry currentTelemetry() {
        return this.openTelemetry.getCurrentSdk();
    }

    static class ForwardedSpan
    implements Span {
        ForwardedSpan() {
        }

        public Span setAttribute(String key, String value) {
            return Span.current().setAttribute(key, value);
        }

        public Span setAttribute(String key, long value) {
            return Span.current().setAttribute(key, value);
        }

        public Span setAttribute(String key, double value) {
            return Span.current().setAttribute(key, value);
        }

        public Span setAttribute(String key, boolean value) {
            return Span.current().setAttribute(key, value);
        }

        public <T> Span setAttribute(AttributeKey<T> key, T value) {
            return Span.current().setAttribute(key, value);
        }

        public Span setAttribute(AttributeKey<Long> key, int value) {
            return Span.current().setAttribute(key, value);
        }

        public Span setAllAttributes(Attributes attributes) {
            return Span.current().setAllAttributes(attributes);
        }

        public Span addEvent(String name) {
            return Span.current().addEvent(name);
        }

        public Span addEvent(String name, long timestamp, TimeUnit unit) {
            return Span.current().addEvent(name, timestamp, unit);
        }

        public Span addEvent(String name, Instant timestamp) {
            return Span.current().addEvent(name, timestamp);
        }

        public Span addEvent(String name, Attributes attributes) {
            return Span.current().addEvent(name, attributes);
        }

        public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
            return Span.current().addEvent(name, attributes, timestamp, unit);
        }

        public Span addEvent(String name, Attributes attributes, Instant timestamp) {
            return Span.current().addEvent(name, attributes, timestamp);
        }

        public Span setStatus(StatusCode statusCode) {
            return Span.current().setStatus(statusCode);
        }

        public Span setStatus(StatusCode statusCode, String description) {
            return Span.current().setStatus(statusCode, description);
        }

        public Span recordException(Throwable exception) {
            return Span.current().recordException(exception);
        }

        public Span recordException(Throwable exception, Attributes additionalAttributes) {
            return Span.current().recordException(exception, additionalAttributes);
        }

        public Span updateName(String name) {
            return Span.current().updateName(name);
        }

        public void end() {
            Span.current().end();
        }

        public void end(long timestamp, TimeUnit unit) {
            Span.current().end(timestamp, unit);
        }

        public void end(Instant timestamp) {
            Span.current().end(timestamp);
        }

        public SpanContext getSpanContext() {
            return Span.current().getSpanContext();
        }

        public boolean isRecording() {
            return Span.current().isRecording();
        }

        public Context storeInContext(Context context) {
            return Span.current().storeInContext(context);
        }
    }

    static class ForwardedBaggage
    implements Baggage {
        ForwardedBaggage() {
        }

        public int size() {
            return Baggage.current().size();
        }

        public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
            Baggage.current().forEach(consumer);
        }

        public Map<String, BaggageEntry> asMap() {
            return Baggage.current().asMap();
        }

        public String getEntryValue(String entryKey) {
            return Baggage.current().getEntryValue(entryKey);
        }

        public BaggageBuilder toBuilder() {
            return Baggage.current().toBuilder();
        }

        public Context storeInContext(Context context) {
            return Baggage.current().storeInContext(context);
        }

        public boolean isEmpty() {
            return Baggage.current().isEmpty();
        }
    }
}

