/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing;

import fish.payara.microprofile.telemetry.tracing.OpenTelemetryTracerProducer;
import fish.payara.microprofile.telemetry.tracing.OpenTracingTracerProducer;
import fish.payara.microprofile.telemetry.tracing.WithSpanMethodInterceptorBean;
import fish.payara.opentracing.OpenTelemetryService;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.internal.api.Globals;

public class TelemetryCdiExtension
implements Extension {
    private final OpenTelemetryService openTelemetryService = (OpenTelemetryService)Globals.getDefaultBaseServiceLocator().getService(OpenTelemetryService.class, new Annotation[0]);
    private boolean appManagedOtel;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        TelemetryCdiExtension.addAnnotatedType(bbd, bm, OpenTracingTracerProducer.class);
        TelemetryCdiExtension.addAnnotatedType(bbd, bm, OpenTelemetryTracerProducer.class);
        bbd.addInterceptorBinding((AnnotatedType)new WithSpanAnnotatedType((AnnotatedType<WithSpan>)bm.createAnnotatedType(WithSpan.class)));
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        abd.addBean((Bean)new WithSpanMethodInterceptorBean(bm));
    }

    static void addAnnotatedType(BeforeBeanDiscovery bbd, BeanManager bm, Class<?> beanClass) {
        AnnotatedType at = bm.createAnnotatedType(beanClass);
        bbd.addAnnotatedType(at, beanClass.getName());
    }

    void initializeOpenTelemetry(@Observes AfterDeploymentValidation adv) {
        try {
            Config config = ConfigProvider.getConfig();
            if (config.getOptionalValue("otel.sdk.disabled", Boolean.class).orElse(true).booleanValue()) {
                return;
            }
            Map<String, String> otelProps = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(key -> key.startsWith("otel.")).collect(Collectors.toMap(k -> k, k -> (String)config.getValue(k, String.class)));
            this.appManagedOtel = true;
            this.openTelemetryService.initializeCurrentApplication(otelProps);
        }
        catch (Exception e) {
            adv.addDeploymentProblem((Throwable)e);
        }
    }

    void shutdownAppScopedTelemetry(@Observes BeforeShutdown beforeShutdown) {
        if (this.appManagedOtel) {
            this.openTelemetryService.shutdownCurrentApplication();
        }
    }

    static class WithSpanAnnotatedType
    implements AnnotatedType<WithSpan> {
        private final AnnotatedType<WithSpan> delegate;
        private final Set<AnnotatedMethod<? super WithSpan>> methods;

        WithSpanAnnotatedType(AnnotatedType<WithSpan> delegate) {
            this.delegate = delegate;
            this.methods = new HashSet<AnnotatedMethod<? super WithSpan>>();
            for (final AnnotatedMethod method : delegate.getMethods()) {
                this.methods.add((AnnotatedMethod<? super WithSpan>)new AnnotatedMethod<WithSpan>(){
                    private final AnnotatedMethod<WithSpan> delegate;
                    private final Set<Annotation> annotations;
                    {
                        this.delegate = method;
                        this.annotations = Collections.singleton(Nonbinding.Literal.INSTANCE);
                    }

                    public Method getJavaMember() {
                        return this.delegate.getJavaMember();
                    }

                    public List<AnnotatedParameter<WithSpan>> getParameters() {
                        return this.delegate.getParameters();
                    }

                    public boolean isStatic() {
                        return this.delegate.isStatic();
                    }

                    public AnnotatedType<WithSpan> getDeclaringType() {
                        return this.delegate.getDeclaringType();
                    }

                    public Type getBaseType() {
                        return this.delegate.getBaseType();
                    }

                    public Set<Type> getTypeClosure() {
                        return this.delegate.getTypeClosure();
                    }

                    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                        if (annotationType.equals(Nonbinding.class)) {
                            return (T)this.annotations.iterator().next();
                        }
                        return null;
                    }

                    public Set<Annotation> getAnnotations() {
                        return this.annotations;
                    }

                    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                        return annotationType.equals(Nonbinding.class);
                    }
                });
            }
        }

        public Class<WithSpan> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<WithSpan>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super WithSpan>> getMethods() {
            return this.methods;
        }

        public Set<AnnotatedField<? super WithSpan>> getFields() {
            return this.delegate.getFields();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }
    }
}

