/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs.client;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.client.ClientRequestContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.opentracing.Traced;

class TracedMethodFilter
implements Predicate<ClientRequestContext> {
    private final boolean classDefault;
    private final Map<Method, Boolean> methodOverrides;

    @Override
    public boolean test(ClientRequestContext clientRequestContext) {
        Object invokedMethod = clientRequestContext.getProperty("org.eclipse.microprofile.rest.client.invokedMethod");
        if (invokedMethod instanceof Method) {
            return this.test((Method)invokedMethod);
        }
        return true;
    }

    @Override
    private boolean test(Method invokedMethod) {
        return this.methodOverrides.getOrDefault(invokedMethod, this.classDefault);
    }

    TracedMethodFilter(Config config, Class<?> clientClass) {
        this.classDefault = TracedMethodFilter.determineClassDefault(config, clientClass);
        this.methodOverrides = new HashMap<Method, Boolean>();
        for (Method method : clientClass.getMethods()) {
            if (!TracedMethodFilter.isRestMethod(method)) continue;
            TracedMethodFilter.determineMethodValue(config, clientClass, method).ifPresent(value -> this.methodOverrides.put(method, (Boolean)value));
        }
    }

    private static boolean isRestMethod(Method m) {
        return TracedMethodFilter.getHttpMethodName(m) != null;
    }

    private static boolean determineClassDefault(Config config, Class<?> clientClass) {
        return Optional.ofNullable(config).flatMap(cfg -> cfg.getOptionalValue(TracedMethodFilter.classOverrideProperty(clientClass), Boolean.TYPE)).orElseGet(() -> TracedMethodFilter.tracedAnnotationValue(clientClass::getAnnotation).orElse(true));
    }

    private static Optional<Boolean> determineMethodValue(Config config, Class<?> clientClass, Method method) {
        Optional<Boolean> configValue = Optional.ofNullable(config).flatMap(cfg -> cfg.getOptionalValue(TracedMethodFilter.methodOverrideProperty(clientClass, method), Boolean.TYPE));
        return configValue.isPresent() ? configValue : TracedMethodFilter.tracedAnnotationValue(method::getAnnotation);
    }

    private static String getHttpMethodName(Method method) {
        Class[] httpMethods;
        for (Class httpMethod : httpMethods = new Class[]{GET.class, POST.class, DELETE.class, PUT.class, HEAD.class, PATCH.class, OPTIONS.class}) {
            if (method.getAnnotation(httpMethod) == null) continue;
            return httpMethod.getSimpleName();
        }
        return null;
    }

    private static String classOverrideProperty(Class<?> clientClass) {
        return clientClass.getCanonicalName() + "/" + Traced.class.getSimpleName() + "/value";
    }

    private static String methodOverrideProperty(Class<?> clientClass, Method method) {
        return clientClass.getCanonicalName() + "/" + method.getName() + "/" + Traced.class.getSimpleName() + "/value";
    }

    private static Optional<Boolean> tracedAnnotationValue(Function<Class<Traced>, Traced> annotationSource) {
        return Optional.ofNullable(annotationSource.apply(Traced.class)).map(Traced::value);
    }
}

