/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ParameterMap;

@Consumes(value={"application/json"})
@Provider
public class JsonParameterMapProvider
implements MessageBodyReader<ParameterMap> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ParameterMap.class);
    }

    @Override
    public ParameterMap readFrom(Class<ParameterMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        ParameterMap parameterMap;
        block13: {
            JsonParser parser = Json.createParser((InputStream)in);
            try {
                JsonObject obj;
                if (parser.hasNext()) {
                    parser.next();
                    obj = parser.getObject();
                } else {
                    obj = JsonValue.EMPTY_JSON_OBJECT;
                }
                ParameterMap map = new ParameterMap();
                for (Map.Entry entry : obj.entrySet()) {
                    JsonValue value = (JsonValue)entry.getValue();
                    if (value instanceof JsonArray) {
                        JsonArray array = (JsonArray)value;
                        for (int i = 0; i < array.size(); ++i) {
                            map.add((Object)((String)entry.getKey()), (Object)JsonParameterMapProvider.getStringValue((JsonValue)array.get(i)));
                        }
                        continue;
                    }
                    map.add((Object)((String)entry.getKey()), (Object)JsonParameterMapProvider.getStringValue(value));
                }
                parameterMap = map;
                if (parser == null) break block13;
            }
            catch (Throwable map) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable) {
                            map.addSuppressed(throwable);
                        }
                    }
                    throw map;
                }
                catch (Exception ex) {
                    Logger.getLogger("org.glassfish.admin.rest").log(Level.SEVERE, null, ex);
                    ParameterMap map2 = new ParameterMap();
                    map2.add((Object)"error", (Object)("Entity Parsing Error: " + ex.getMessage()));
                    return map2;
                }
            }
            parser.close();
        }
        return parameterMap;
    }

    private static String getStringValue(JsonValue json) {
        if (json == null) {
            return "";
        }
        if (json instanceof JsonString) {
            return ((JsonString)json).getString();
        }
        return json.toString();
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        StringBuilder sb;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

