/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.audit.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.audit.AdminAuditConfiguration;
import fish.payara.audit.AdminAuditService;
import fish.payara.audit.AuditLevel;
import fish.payara.internal.notification.NotifierUtils;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-admin-audit-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=AdminAuditConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-admin-audit-configuration", description="Sets the Configuration for the Admin Audit Service")})
public class SetAdminAuditConfiguration
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(SetAdminAuditConfiguration.class.getPackage().toString());
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="auditLevel", optional=true, acceptableValues="MODIFIERS, ACCESSORS, INTERNAL")
    private String auditLevel;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    private Config targetConfig;
    @Param(name="enableNotifiers", alias="enable-notifiers", optional=true)
    private List<String> enableNotifiers;
    @Param(name="disableNotifiers", alias="disable-notifiers", optional=true)
    private List<String> disableNotifiers;
    @Param(name="setNotifiers", alias="set-notifiers", optional=true)
    private List<String> setNotifiers;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private AdminAuditService auditService;
    @Inject
    private Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.targetConfig = this.targetUtil.getConfig(this.target);
        AdminAuditConfiguration configuration = (AdminAuditConfiguration)this.targetConfig.getExtensionByType(AdminAuditConfiguration.class);
        try {
            final Set notifierNames = NotifierUtils.getNotifierNames((ServiceLocator)this.serviceLocator);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AdminAuditConfiguration>(){

                public Object run(AdminAuditConfiguration proxy) throws PropertyVetoException, TransactionFailure {
                    if (SetAdminAuditConfiguration.this.enabled != null) {
                        proxy.enabled(SetAdminAuditConfiguration.this.enabled.toString());
                    }
                    if (SetAdminAuditConfiguration.this.auditLevel != null) {
                        proxy.setAuditLevel(SetAdminAuditConfiguration.this.auditLevel);
                    }
                    List<String> notifiers = proxy.getNotifierList();
                    if (SetAdminAuditConfiguration.this.enableNotifiers != null) {
                        for (String notifier : SetAdminAuditConfiguration.this.enableNotifiers) {
                            if (notifierNames.contains(notifier)) {
                                if (notifiers.contains(notifier)) continue;
                                notifiers.add(notifier);
                                continue;
                            }
                            throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                        }
                    }
                    if (SetAdminAuditConfiguration.this.disableNotifiers != null) {
                        for (String notifier : SetAdminAuditConfiguration.this.disableNotifiers) {
                            if (notifierNames.contains(notifier)) {
                                notifiers.remove(notifier);
                                continue;
                            }
                            throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                        }
                    }
                    if (SetAdminAuditConfiguration.this.setNotifiers != null) {
                        notifiers.clear();
                        for (String notifier : SetAdminAuditConfiguration.this.setNotifiers) {
                            if (notifierNames.contains(notifier)) {
                                if (notifiers.contains(notifier)) continue;
                                notifiers.add(notifier);
                                continue;
                            }
                            throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(proxy, "notifiers", notifiers, notifiers));
                        }
                    }
                    return null;
                }
            }, (ConfigBeanProxy)configuration);
            if (this.dynamic != null && this.dynamic.booleanValue() && this.target.equals("server-config")) {
                this.auditService.setEnabled(this.enabled);
                this.auditService.setAuditLevel(AuditLevel.valueOf(this.auditLevel));
                Set<String> notifiers = this.auditService.getEnabledNotifiers();
                if (this.enableNotifiers != null) {
                    this.enableNotifiers.forEach(notifiers::add);
                }
                if (this.disableNotifiers != null) {
                    this.disableNotifiers.forEach(notifiers::remove);
                }
                if (this.setNotifiers != null) {
                    notifiers.clear();
                    this.setNotifiers.forEach(notifiers::add);
                }
            }
        }
        catch (TransactionFailure ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            report.setMessage(ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

