/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring;

import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationBuilder;
import fish.payara.internal.notification.PayaraNotificationFactory;
import fish.payara.jmx.monitoring.JMXMonitoringJob;
import fish.payara.jmx.monitoring.JMXMonitoringService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServer;
import org.glassfish.hk2.api.messaging.Topic;

public class JMXMonitoringFormatter
implements Runnable {
    private final String LOGMESSAGE_PREFIX = "JMX-MONITORING:";
    private final String NOTIFICATION_SUBJECT = "MBean Attributes: ";
    private final MBeanServer mBeanServer;
    private final List<JMXMonitoringJob> JmxMonitoringJobs;
    private final JMXMonitoringService monitoringService;
    private final Collection<String> enabledNotifiers;
    private Topic<PayaraNotification> notificationEventBus;
    private PayaraNotificationFactory notificationFactory;

    public JMXMonitoringFormatter(MBeanServer mBeanServer, List<JMXMonitoringJob> jobs, JMXMonitoringService monitoringService, Topic<PayaraNotification> notificationEventBus, PayaraNotificationFactory notificationFactory, Collection<String> enabledNotifiers) {
        this.mBeanServer = mBeanServer;
        this.JmxMonitoringJobs = jobs;
        this.monitoringService = monitoringService;
        this.notificationEventBus = notificationEventBus;
        this.notificationFactory = notificationFactory;
        this.enabledNotifiers = enabledNotifiers;
    }

    @Override
    public void run() {
        StringBuilder monitoringString = new StringBuilder();
        monitoringString.append("MBean Attributes: ");
        for (JMXMonitoringJob job : this.JmxMonitoringJobs) {
            monitoringString.append(job.getMonitoringInfo(this.mBeanServer));
        }
        this.sendNotification(Level.INFO, monitoringString.toString(), this.JmxMonitoringJobs.toArray());
    }

    private void sendNotification(Level level, String message, Object[] parameters) {
        PayaraNotificationBuilder notification = this.notificationFactory.newBuilder().whitelist(this.enabledNotifiers.toArray(new String[0])).subject("JMX-MONITORING:" + message).level(EventLevel.INFO);
        if (parameters != null && parameters.length > 0) {
            notification = notification.message(MessageFormat.format(message, parameters));
        }
        this.notificationEventBus.publish((Object)notification.build());
    }
}

